/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.List;
import org.junit.Assert;
import org.scijava.sjep.Function;
import org.scijava.sjep.SyntaxTree;
import org.scijava.sjep.Variable;

public class AbstractTest {
    protected void assertString(String expected, Object actual) {
        Assert.assertSame(expected.getClass(), actual.getClass());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertNumber(Number expected, Object actual) {
        Assert.assertSame(expected.getClass(), actual.getClass());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertFunction(String expected, int arity, Object token) {
        this.assertInstance(token, Function.class);
        Function function = (Function)token;
        Assert.assertEquals((Object)expected, (Object)function.getToken());
        Assert.assertEquals((long)arity, (long)function.getArity());
    }

    protected void assertVariable(String expected, Object token) {
        this.assertInstance(token, Variable.class);
        Assert.assertEquals((Object)expected, (Object)((Variable)token).getToken());
    }

    protected void assertInstance(Object token, Class<?> c) {
        Assert.assertTrue((String)token.getClass().getName(), (boolean)c.isInstance(token));
    }

    protected void assertCount(int expected, SyntaxTree tree) {
        Assert.assertEquals((long)expected, (long)tree.count());
    }

    protected void assertToken(String expected, Object token) {
        Assert.assertEquals((Object)expected, (Object)token.toString());
    }

    protected void assertSameLists(List<?> expected, List<?> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertSame((String)("Non-matching index: " + i), expected.get(i), actual.get(i));
        }
    }
}

