/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.TypeAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class TypeAdapter {
    public Object target;
    public Fixture fixture;
    public Field field;
    public Method method;
    public Class<?> type;
    public boolean isRegex;
    private static final Map<Class<?>, TypeAdapter> PARSE_DELEGATES = new HashMap();

    public static TypeAdapter on(Fixture target, Class<?> type) {
        TypeAdapter a = TypeAdapter.adapterFor(type);
        a.init(target, type);
        return a;
    }

    public static TypeAdapter on(Fixture fixture, Field field) {
        TypeAdapter a = TypeAdapter.on((Fixture)fixture, field.getType());
        a.target = fixture;
        a.field = field;
        a.field.setAccessible(true);
        return a;
    }

    public static TypeAdapter on(Fixture fixture, Method method) {
        return TypeAdapter.on((Fixture)fixture, (Method)method, (boolean)false);
    }

    public static TypeAdapter on(Fixture fixture, Method method, boolean isRegex) {
        TypeAdapter a = TypeAdapter.on((Fixture)fixture, method.getReturnType());
        a.target = fixture;
        a.method = method;
        a.isRegex = isRegex;
        return a;
    }

    public static TypeAdapter adapterFor(Class<?> type) throws UnsupportedOperationException {
        if (type.isPrimitive()) {
            if (type.equals(Byte.TYPE)) {
                return new ByteAdapter();
            }
            if (type.equals(Short.TYPE)) {
                return new ShortAdapter();
            }
            if (type.equals(Integer.TYPE)) {
                return new IntAdapter();
            }
            if (type.equals(Long.TYPE)) {
                return new LongAdapter();
            }
            if (type.equals(Float.TYPE)) {
                return new FloatAdapter();
            }
            if (type.equals(Double.TYPE)) {
                return new DoubleAdapter();
            }
            if (type.equals(Character.TYPE)) {
                return new CharAdapter();
            }
            if (type.equals(Boolean.TYPE)) {
                return new BooleanAdapter();
            }
            throw new UnsupportedOperationException("can't yet adapt " + type);
        }
        Object delegate = PARSE_DELEGATES.get(type);
        if (delegate instanceof DelegateClassAdapter) {
            return (TypeAdapter)((DelegateClassAdapter)delegate).clone();
        }
        if (delegate instanceof DelegateObjectAdapter) {
            return (TypeAdapter)((DelegateObjectAdapter)delegate).clone();
        }
        if (type.equals(Byte.class)) {
            return new ClassByteAdapter();
        }
        if (type.equals(Short.class)) {
            return new ClassShortAdapter();
        }
        if (type.equals(Integer.class)) {
            return new ClassIntegerAdapter();
        }
        if (type.equals(Long.class)) {
            return new ClassLongAdapter();
        }
        if (type.equals(Float.class)) {
            return new ClassFloatAdapter();
        }
        if (type.equals(Double.class)) {
            return new ClassDoubleAdapter();
        }
        if (type.equals(Character.class)) {
            return new ClassCharacterAdapter();
        }
        if (type.equals(Boolean.class)) {
            return new ClassBooleanAdapter();
        }
        if (type.isArray()) {
            return new ArrayAdapter();
        }
        return new TypeAdapter();
    }

    public void init(Fixture fixture, Class<?> type) {
        this.fixture = fixture;
        this.type = type;
    }

    public Object get() throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(this.target);
        }
        if (this.method != null) {
            return this.invoke();
        }
        return null;
    }

    public void set(Object value) throws Exception {
        this.field.set(this.target, value);
    }

    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{};
        return this.method.invoke(this.target, params);
    }

    public Object parse(String s) throws Exception {
        String obj = this.isRegex ? s : this.fixture.parse(s, this.type);
        return obj;
    }

    public boolean equals(Object a, Object b) {
        boolean isEqual = false;
        isEqual = this.isRegex ? Pattern.matches(a.toString(), b.toString()) : (a == null ? b == null : a.equals(b));
        return isEqual;
    }

    public String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String && ((String)o).equals("")) {
            return "blank";
        }
        return o.toString();
    }

    public static void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        try {
            PARSE_DELEGATES.put(type, new DelegateClassAdapter(parseDelegate));
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate class " + parseDelegate.getName() + " does not have a suitable static parse() method.");
        }
    }

    public static void registerParseDelegate(Class<?> type, Object parseDelegate) {
        try {
            PARSE_DELEGATES.put(type, new DelegateObjectAdapter(parseDelegate));
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate object of class " + parseDelegate.getClass().getName() + " does not have a suitable parse() method.");
        }
    }

    public static void clearDelegatesForNextTest() {
        PARSE_DELEGATES.clear();
    }
}

