/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.HashingCipher;
import java.util.Random;
import junit.framework.TestCase;
import util.TimeMeasurement;

/*
 * Exception performing whole class analysis ignored.
 */
public class HashingCipherTest
extends TestCase {
    private String[] inputs = new String[]{"123", "abc", "12345678901234567890", "this is a test", "!@#$%^&*()"};
    private HashingCipher crypter = new HashingCipher();

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testHashReturnsDifferentValueThanPassed() throws Exception {
        String testString = "This is a test string";
        String hash = this.crypter.encrypt(testString);
        HashingCipherTest.assertNotNull((Object)hash);
        HashingCipherTest.assertFalse((boolean)hash.equals(testString));
    }

    public void testDifferentStringHashDifferently() throws Exception {
        String hash1 = this.crypter.encrypt("123456");
        String hash2 = this.crypter.encrypt("abcdef");
        HashingCipherTest.assertFalse((boolean)hash1.equals(hash2));
    }

    public void testLengthOfHash() throws Exception {
        for (int i = 0; i < this.inputs.length; ++i) {
            String input = this.inputs[i];
            String encryption = this.crypter.encrypt(input);
            HashingCipherTest.assertEquals((String)input, (int)20, (int)encryption.length());
        }
    }

    public void testSameInputGivesSameOutput() throws Exception {
        for (int i = 0; i < this.inputs.length; ++i) {
            String input = this.inputs[i];
            String encryption1 = this.crypter.encrypt(input);
            String encryption2 = this.crypter.encrypt(input);
            HashingCipherTest.assertEquals((String)input, (String)encryption1, (String)encryption2);
        }
    }

    public void testAlgorithmSpeed() throws Exception {
        Random generator = new Random();
        int sampleSize = 1000;
        String[] inputs = new String[sampleSize];
        for (int i = 0; i < inputs.length; ++i) {
            int passwordSize = generator.nextInt(20) + 1;
            byte[] passwd = new byte[passwordSize];
            generator.nextBytes(passwd);
            inputs[i] = new String(passwd);
        }
        TimeMeasurement measurement = new TimeMeasurement().start();
        for (int i = 0; i < inputs.length; ++i) {
            this.crypter.encrypt(inputs[i]);
        }
        long duration = measurement.elapsed();
        HashingCipherTest.assertTrue((duration < 1000L ? 1 : 0) != 0);
    }
}

