/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.AttributeWikiPageFinder;
import fitnesse.components.TraversalListener;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AttributeWikiPageFinderTest
implements TraversalListener<WikiPage> {
    private WikiPage root;
    private PageCrawler crawler;
    private WikiPage page;
    private AttributeWikiPageFinder searcher;
    private List<WikiPage> hits = new ArrayList();

    public void process(WikiPage page) {
        this.hits.add(page);
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.searcher = new AttributeWikiPageFinder((TraversalListener)this, Arrays.asList(PageType.TEST), new HashMap(), new ArrayList());
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"));
        this.hits.clear();
    }

    @Test
    public void testPageMatchesQueryWithSingleAttribute() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        this.searcher = new AttributeWikiPageFinder((TraversalListener)this, Arrays.asList(PageType.TEST), attributes, new ArrayList());
        attributes.put(PageType.TEST.toString(), true);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.removePageProperty(this.page, PageType.TEST.toString());
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(Arrays.asList(PageType.STATIC, PageType.SUITE), attributes);
        attributes.put(PageType.TEST.toString(), false);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, PageType.TEST.toString(), "true");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    private AttributeWikiPageFinder generateSearcherByPageTypesAndSearchAttributes(List<PageType> pageTypes, Map<String, Boolean> attributes) {
        return new AttributeWikiPageFinder((TraversalListener)this, pageTypes, attributes, new ArrayList());
    }

    private void removePageProperty(WikiPage page, String attributeName) throws Exception {
        PageData pageData = page.getData();
        pageData.getProperties().remove(attributeName);
        page.commit(pageData);
    }

    private void setPageProperty(WikiPage page, String propertyName) {
        PageData pageData = page.getData();
        pageData.setAttribute(propertyName);
        page.commit(pageData);
    }

    private void setPageProperty(WikiPage page, String propertyName, String propertyValue) {
        PageData pageData = page.getData();
        pageData.setAttribute(propertyName, propertyValue);
        page.commit(pageData);
    }

    @Test
    public void testPageMatchesQueryWithMultipleAttributes() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(Arrays.asList(PageType.TEST), attributes);
        this.removePageProperty(this.page, PageType.TEST.toString());
        attributes.put(PageType.TEST.toString(), true);
        attributes.put(PageType.SUITE.toString(), true);
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        attributes.put(PageType.SUITE.toString(), false);
        this.setPageProperty(this.page, PageType.TEST.toString());
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        attributes.put(PageType.TEST.toString(), false);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.removePageProperty(this.page, PageType.TEST.toString());
        this.setPageProperty(this.page, PageType.SUITE.toString());
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithExcludedSetUps() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", false);
        List<PageType> pageTypes = Arrays.asList(PageType.TEST, PageType.STATIC, PageType.SUITE);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString());
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithIncludedSetUps() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", true);
        List<PageType> pageTypes = Arrays.asList(PageType.TEST, PageType.STATIC, PageType.SUITE);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString());
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithExcludedTearDowns() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("TearDown", false);
        List<PageType> pageTypes = Arrays.asList(PageType.SUITE, PageType.TEST, PageType.STATIC);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString());
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithIncludedTearDowns() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("TearDown", true);
        List<PageType> pageTypes = Arrays.asList(PageType.TEST, PageType.STATIC, PageType.SUITE);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString());
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchWithNullSuites() throws Exception {
        this.searcher = this.generateSearcherByPagesTypesAndSuites(Arrays.asList(PageType.TEST), null);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest");
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
    }

    private AttributeWikiPageFinder generateSearcherByPagesTypesAndSuites(List<PageType> pageTypes, List<String> suites) {
        return new AttributeWikiPageFinder((TraversalListener)this, pageTypes, new HashMap(), suites);
    }

    @Test
    public void testPageMatchWithEmptySuites() throws Exception {
        HashMap requestInputs = new HashMap();
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(Arrays.asList(PageType.TEST), requestInputs);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchQueryWithSingleSuite() throws Exception {
        List<String> suites = Arrays.asList("SuiteTest");
        this.searcher = this.generateSearcherByPagesTypesAndSuites(Arrays.asList(PageType.TEST), suites);
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest");
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest, SuiteTest2");
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest2 , SuiteTest3");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchQueryWithMultipleSuites() throws Exception {
        List<String> suites = Arrays.asList("SuiteTest2", "SuiteTest3");
        this.searcher = this.generateSearcherByPagesTypesAndSuites(Arrays.asList(PageType.TEST), suites);
        this.setPageProperty(this.page, "Suites", "SuiteTest2 , SuiteTest3");
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.setPageProperty(this.page, "Suites", "SuiteTest, SuiteTest2");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testCheckAttributeValue() {
        Assert.assertTrue((boolean)this.searcher.attributeMatchesInput(false, false));
        Assert.assertTrue((boolean)this.searcher.attributeMatchesInput(true, true));
        Assert.assertFalse((boolean)this.searcher.attributeMatchesInput(false, true));
        Assert.assertTrue((boolean)this.searcher.attributeMatchesInput(true, false));
    }

    @Test
    public void testSetUpAndTearDownMatches() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", true);
        attributes.put("TearDown", true);
        this.setPageProperty(this.page, PageType.TEST.toString(), "true");
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(Arrays.asList(PageType.STATIC), attributes);
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithExcludedSetUpsAndIncludedTearDowns() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", false);
        attributes.put("TearDown", true);
        List<PageType> pageTypes = Arrays.asList(PageType.TEST, PageType.STATIC, PageType.SUITE);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString(), "true");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testPageMatchesQueryWithIncludedSetUpsAndExcludedSetUps() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", true);
        attributes.put("TearDown", false);
        List<PageType> pageTypes = Arrays.asList(PageType.STATIC);
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        this.setPageProperty(this.page, PageType.TEST.toString(), "true");
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }

    @Test
    public void testSetUpAndTearDownExcluded() throws Exception {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("SetUp", false);
        attributes.put("TearDown", false);
        List<PageType> pageTypes = Arrays.asList(PageType.TEST, PageType.SUITE, PageType.STATIC);
        this.setPageProperty(this.page, PageType.TEST.toString(), "true");
        this.searcher = this.generateSearcherByPageTypesAndSearchAttributes(pageTypes, attributes);
        Assert.assertTrue((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"TearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"));
        Assert.assertFalse((boolean)this.searcher.pageMatches(this.page));
    }
}

