/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.PluginsClassLoader;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class PluginsClassLoaderTest {
    @Test
    public void whenPluginsDirectoryDoesNotExist() {
        try {
            PluginsClassLoader pluginsClassLoader = new PluginsClassLoader();
            pluginsClassLoader.pluginsDirectory = "nonExistingPluginsDirectory";
            Assert.assertFalse((boolean)new File(pluginsClassLoader.pluginsDirectory).exists());
            pluginsClassLoader.addPluginsToClassLoader();
            Assert.assertTrue((String)"didn't cause exception", (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"if exception occurs when plugins directory does not exist");
        }
    }

    @Test
    public void addPluginsToClassLoader() throws Exception {
        String[] dynamicClasses = new String[]{"fitnesse.testing.PluginX", "fitnesse.testing.PluginY"};
        PluginsClassLoader pluginsClassLoader = new PluginsClassLoader();
        Assert.assertTrue((boolean)new File(pluginsClassLoader.pluginsDirectory).exists());
        pluginsClassLoader.addPluginsToClassLoader();
        this.assertLoadingClassWorksNow(dynamicClasses);
    }

    private void assertLoadingClassWorksNow(String ... dynamicClasses) {
        for (String dynamicClass : dynamicClasses) {
            try {
                Class<?> dynamicallyLoadedClass = Class.forName(dynamicClass);
                Assert.assertEquals((Object)dynamicClass, (Object)dynamicallyLoadedClass.getName());
            }
            catch (ClassNotFoundException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void assertLoadingClassCausesException(String ... dynamicClasses) {
        for (String dynamicClass : dynamicClasses) {
            try {
                Class.forName(dynamicClass);
                Assert.fail((String)"plugins are not yet added to the classloader");
            }
            catch (ClassNotFoundException e) {
                Assert.assertEquals((Object)dynamicClass, (Object)e.getMessage());
            }
        }
    }
}

