/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.TraversalListener;
import fitnesse.components.WhereUsedPageFinder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WhereUsedPageFinderTest
extends RegexTestCase
implements TraversalListener<WikiPage> {
    private WikiPage root;
    private InMemoryPage pageOne;
    private WikiPage pageTwo;
    private WikiPage pageThree;
    private WhereUsedPageFinder whereUsed;
    private List<WikiPage> hits = new ArrayList();
    private PageCrawler crawler;

    public void process(WikiPage page) {
        this.hits.add(page);
    }

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.pageOne = (InMemoryPage)this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "this is page one ^ChildPage");
        this.pageTwo = this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"), "I am Page Two my brother is PageOne . SomeMissingPage");
        this.pageThree = this.crawler.addPage(this.root, PathParser.parse((String)"PageThree"), "This is !-PageThree-!, I Have \n!include PageTwo");
        this.crawler.addPage(this.pageTwo, PathParser.parse((String)"ChildPage"), "I will be a virtual page to .PageOne ");
        this.whereUsed = new WhereUsedPageFinder(this.root, (TraversalListener)this);
        this.hits.clear();
    }

    public void testFindReferencingPages() throws Exception {
        this.whereUsed = new WhereUsedPageFinder((WikiPage)this.pageOne, (TraversalListener)this);
        List resultList = this.whereUsed.search(this.root);
        WhereUsedPageFinderTest.assertEquals((int)2, (int)resultList.size());
        WhereUsedPageFinderTest.assertEquals((Object)this.pageTwo, resultList.get(0));
        this.whereUsed = new WhereUsedPageFinder(this.pageTwo, (TraversalListener)this);
        resultList = this.whereUsed.search(this.root);
        WhereUsedPageFinderTest.assertEquals((int)1, (int)resultList.size());
        this.whereUsed = new WhereUsedPageFinder(this.pageThree, (TraversalListener)this);
        resultList = this.whereUsed.search(this.root);
        WhereUsedPageFinderTest.assertEquals((int)0, (int)resultList.size());
    }

    public void testObserving() throws Exception {
        this.whereUsed = new WhereUsedPageFinder((WikiPage)this.pageOne, (TraversalListener)this);
        this.whereUsed.search(this.root);
        WhereUsedPageFinderTest.assertEquals((int)2, (int)this.hits.size());
    }

    public void testOnlyOneReferencePerPage() throws Exception {
        this.whereUsed = new WhereUsedPageFinder(this.pageThree, (TraversalListener)this);
        WikiPage newPage = this.crawler.addPage(this.root, PathParser.parse((String)"NewPage"), "one reference to PageThree.  Two reference to PageThree");
        List resultList = this.whereUsed.search(this.root);
        WhereUsedPageFinderTest.assertEquals((int)1, (int)resultList.size());
        WhereUsedPageFinderTest.assertEquals((Object)newPage, resultList.get(0));
    }

    public void testWordsNotFoundInPreprocessedText() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"NewPage"), "{{{ PageThree }}}");
        List resultList = this.whereUsed.search(this.pageThree);
        WhereUsedPageFinderTest.assertEquals((int)0, (int)resultList.size());
    }
}

