/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.MockChunkedDataProvider;
import fitnesse.http.ResponseSender;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class ChunkedResponseTest
implements ResponseSender {
    private ChunkedResponse response;
    private boolean closed = false;
    public StringBuffer buffer;

    public void send(byte[] bytes) {
        try {
            this.buffer.append(new String(bytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error in encoding", e);
        }
    }

    public void close() {
        this.closed = true;
    }

    public Socket getSocket() {
        return null;
    }

    @Before
    public void setUp() throws Exception {
        this.buffer = new StringBuffer();
        this.response = new ChunkedResponse("html", (ChunkedDataProvider)new MockChunkedDataProvider());
        this.response.sendTo((ResponseSender)this);
    }

    @After
    public void tearDown() throws Exception {
        this.response.closeAll();
    }

    @Test
    public void testHeaders() throws Exception {
        String text = this.buffer.toString();
        RegexTestCase.assertHasRegexp((String)"Transfer-Encoding: chunked", (String)text);
        Assert.assertTrue((boolean)text.startsWith("HTTP/1.1 200 OK\r\n"));
        RegexTestCase.assertHasRegexp((String)"Content-Type: text/html", (String)text);
    }

    @Test
    public void xmlHeaders() throws Exception {
        this.response = new ChunkedResponse("xml", (ChunkedDataProvider)new MockChunkedDataProvider());
        this.response.sendTo((ResponseSender)this);
        String text = this.buffer.toString();
        RegexTestCase.assertHasRegexp((String)"Transfer-Encoding: chunked", (String)text);
        Assert.assertTrue((boolean)text.startsWith("HTTP/1.1 200 OK\r\n"));
        RegexTestCase.assertHasRegexp((String)"Content-Type: text/xml", (String)text);
    }

    @Test
    public void testOneChunk() throws Exception {
        this.buffer = new StringBuffer();
        this.response.add("some more text");
        String text = this.buffer.toString();
        Assert.assertEquals((Object)"e\r\nsome more text\r\n", (Object)text);
    }

    @Test
    public void testTwoChunks() throws Exception {
        this.buffer = new StringBuffer();
        this.response.add("one");
        this.response.add("two");
        String text = this.buffer.toString();
        Assert.assertEquals((Object)"3\r\none\r\n3\r\ntwo\r\n", (Object)text);
    }

    @Test
    public void testSimpleClosing() throws Exception {
        Assert.assertFalse((boolean)this.closed);
        this.buffer = new StringBuffer();
        this.response.closeAll();
        String text = this.buffer.toString();
        Assert.assertEquals((Object)"0\r\n\r\n", (Object)text);
        Assert.assertTrue((boolean)this.closed);
    }

    @Test
    public void testClosingInSteps() throws Exception {
        Assert.assertFalse((boolean)this.closed);
        this.buffer = new StringBuffer();
        this.response.closeChunks();
        Assert.assertEquals((Object)"0\r\n", (Object)this.buffer.toString());
        Assert.assertFalse((boolean)this.closed);
        this.buffer = new StringBuffer();
        this.response.closeTrailer();
        Assert.assertEquals((Object)"\r\n", (Object)this.buffer.toString());
        Assert.assertFalse((boolean)this.closed);
        this.response.close();
        Assert.assertTrue((boolean)this.closed);
    }

    @Test
    public void testContentSize() throws Exception {
        this.response.add("12345");
        this.response.closeAll();
        Assert.assertEquals((long)5L, (long)this.response.getContentSize());
    }

    @Test
    public void testNoNullPointerException() throws Exception {
        String s = null;
        try {
            this.response.add(s);
        }
        catch (Exception e) {
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testTrailingHeaders() throws Exception {
        this.response.closeChunks();
        this.buffer = new StringBuffer();
        this.response.addTrailingHeader("Some-Header", "someValue");
        Assert.assertEquals((Object)"Some-Header: someValue\r\n", (Object)this.buffer.toString());
        this.response.closeTrailer();
        this.response.close();
        Assert.assertTrue((boolean)this.closed);
    }

    @Test
    public void testCantAddZeroLengthBytes() throws Exception {
        int originalLength = this.buffer.length();
        this.response.add("");
        Assert.assertEquals((long)originalLength, (long)this.buffer.length());
        this.response.closeAll();
    }

    @Test
    public void testUnicodeCharacters() throws Exception {
        this.response.add("\uba80\uba81\uba82\uba83");
        this.response.closeAll();
        RegexTestCase.assertSubString((String)"\uba80\uba81\uba82\uba83", (String)this.buffer.toString());
    }

    @Test
    public void testTurnOffChunking() {
        this.response.turnOffChunking();
        this.response.add("one");
        this.response.add("two");
        this.response.closeAll();
        RegexTestCase.assertMatches((String)"onetwo$", (String)this.buffer.toString());
    }
}

