/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseTest;
import org.junit.Assert;
import org.junit.Test;

public class ResponseTest {
    @Test
    public void reasonCode() throws Exception {
        this.checkPhrase(100, "Continue");
        this.checkPhrase(101, "Switching Protocols");
        this.checkPhrase(200, "OK");
        this.checkPhrase(201, "Created");
        this.checkPhrase(202, "Accepted");
        this.checkPhrase(203, "Non-Authoritative Information");
        this.checkPhrase(204, "No Content");
        this.checkPhrase(205, "Reset Content");
        this.checkPhrase(300, "Multiple Choices");
        this.checkPhrase(301, "Moved Permanently");
        this.checkPhrase(302, "Found");
        this.checkPhrase(303, "See Other");
        this.checkPhrase(304, "Not Modified");
        this.checkPhrase(305, "Use Proxy");
        this.checkPhrase(307, "Temporary Redirect");
        this.checkPhrase(400, "Bad Request");
        this.checkPhrase(401, "Unauthorized");
        this.checkPhrase(402, "Payment Required");
        this.checkPhrase(403, "Forbidden");
        this.checkPhrase(404, "Not Found");
        this.checkPhrase(405, "Method Not Allowed");
        this.checkPhrase(406, "Not Acceptable");
        this.checkPhrase(407, "Proxy Authentication Required");
        this.checkPhrase(408, "Request Time-out");
        this.checkPhrase(409, "Conflict");
        this.checkPhrase(410, "Gone");
        this.checkPhrase(411, "Length Required");
        this.checkPhrase(412, "Precondition Failed");
        this.checkPhrase(413, "Request Entity Too Large");
        this.checkPhrase(414, "Request-URI Too Large");
        this.checkPhrase(415, "Unsupported Media Type");
        this.checkPhrase(416, "Requested range not satisfiable");
        this.checkPhrase(417, "Expectation Failed");
        this.checkPhrase(500, "Internal Server Error");
        this.checkPhrase(501, "Not Implemented");
        this.checkPhrase(502, "Bad Gateway");
        this.checkPhrase(503, "Service Unavailable");
        this.checkPhrase(504, "Gateway Time-out");
        this.checkPhrase(505, "HTTP Version not supported");
        this.checkPhrase(-1, "Unknown Status");
    }

    private void checkPhrase(int reasonCode, String reasonPhrase) {
        Assert.assertEquals((Object)reasonPhrase, (Object)Response.getReasonPhrase((int)reasonCode));
    }

    @Test
    public void htmlFormat() throws Exception {
        MockResponse response = new MockResponse(this, "html");
        Assert.assertTrue((boolean)response.isHtmlFormat());
    }

    @Test
    public void xmlFormat() throws Exception {
        MockResponse response = new MockResponse(this, "xml");
        Assert.assertTrue((boolean)response.isXmlFormat());
    }

    @Test
    public void textFormat() throws Exception {
        MockResponse response = new MockResponse(this, "text");
        Assert.assertTrue((boolean)response.isTextFormat());
    }

    @Test
    public void defaultFormat() throws Exception {
        MockResponse response = new MockResponse(this, "");
        Assert.assertTrue((boolean)response.isHtmlFormat());
    }

    @Test
    public void shouldNotHaveHeadersIfText() throws Exception {
        MockResponse response = new MockResponse(this, "text");
        Assert.assertEquals((Object)"", (Object)response.makeHttpHeaders());
    }

    @Test
    public void shouldHaveHeadersIfHtml() throws Exception {
        MockResponse response = new MockResponse(this, "html");
        Assert.assertTrue((boolean)response.makeHttpHeaders().contains("HTTP/1.1 200 OK"));
    }

    @Test
    public void shouldHaveHeadersIfXml() throws Exception {
        MockResponse response = new MockResponse(this, "xml");
        Assert.assertTrue((boolean)response.makeHttpHeaders().contains("HTTP/1.1 200 OK"));
    }
}

