/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.MockChunkedDataProvider;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.WikiImporterTest;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiImportingResponderAuthenticationTest
extends RegexTestCase {
    private WikiImportingResponder responder;
    private String baseUrl;
    private WikiImporterTest testData;

    public void setUp() throws Exception {
        this.testData = new WikiImporterTest();
        this.testData.createRemoteRoot();
        this.testData.createLocalRoot();
        FitNesseContext context = FitNesseUtil.makeTestContext((WikiPage)this.testData.remoteRoot, (Authenticator)new OneUserAuthenticator("joe", "blow"));
        FitNesseUtil.startFitnesseWithContext((FitNesseContext)context);
        this.baseUrl = "http://localhost:1999/";
        this.createResponder();
    }

    private void createResponder() throws Exception {
        this.responder = new WikiImportingResponder();
        this.responder.path = new WikiPagePath();
        ChunkedResponse response = new ChunkedResponse("html", (ChunkedDataProvider)new MockChunkedDataProvider());
        response.sendTo((ResponseSender)new MockResponseSender());
        this.responder.setResponse(response);
        this.responder.getImporter().setDeleteOrphanOption(false);
    }

    public void tearDown() throws Exception {
        FitNesseUtil.stopFitnesse();
    }

    private void makeSecurePage(WikiPage page) throws Exception {
        PageData data = page.getData();
        data.setAttribute("secure-read");
        page.commit(data);
    }

    private void checkRemoteLoginForm(String content) {
        WikiImportingResponderAuthenticationTest.assertHasRegexp((String)"The wiki at .* requires authentication.", (String)content);
        WikiImportingResponderAuthenticationTest.assertSubString((String)"<form", (String)content);
        WikiImportingResponderAuthenticationTest.assertHasRegexp((String)"<input[^>]*name=\"remoteUsername\"", (String)content);
        WikiImportingResponderAuthenticationTest.assertHasRegexp((String)"<input[^>]*name=\"remotePassword\"", (String)content);
    }

    private MockRequest makeRequest(String remoteUrl) {
        MockRequest request = new MockRequest();
        request.setResource("PageTwo");
        request.addInput("responder", (Object)"import");
        request.addInput("remoteUrl", (Object)remoteUrl);
        return request;
    }

    private ChunkedResponse makeSampleResponse(String remoteUrl) {
        MockRequest request = this.makeRequest(remoteUrl);
        return this.getResponse(request);
    }

    private ChunkedResponse getResponse(MockRequest request) {
        ChunkedResponse response = (ChunkedResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.testData.localRoot), (Request)request);
        response.turnOffChunking();
        return response;
    }

    public void testUnauthorizedResponse() throws Exception {
        this.makeSecurePage(this.testData.remoteRoot);
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        this.checkRemoteLoginForm(content);
    }

    public void testUnauthorizedResponseFromNonRoot() throws Exception {
        WikiPage childPage = this.testData.remoteRoot.getChildPage("PageOne");
        this.makeSecurePage(childPage);
        ChunkedResponse response = this.makeSampleResponse(this.baseUrl);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        WikiImportingResponderAuthenticationTest.assertSubString((String)("The wiki at " + this.baseUrl + "PageOne requires authentication."), (String)content);
        WikiImportingResponderAuthenticationTest.assertSubString((String)"<form", (String)content);
    }

    public void testImportingFromSecurePageWithCredentials() throws Exception {
        this.makeSecurePage(this.testData.remoteRoot);
        MockRequest request = this.makeRequest(this.baseUrl);
        request.addInput("remoteUsername", (Object)"joe");
        request.addInput("remotePassword", (Object)"blow");
        ChunkedResponse response = this.getResponse(request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)response);
        String content = sender.sentData();
        WikiImportingResponderAuthenticationTest.assertNotSubString((String)"requires authentication", (String)content);
        WikiImportingResponderAuthenticationTest.assertSubString((String)"3 pages were imported.", (String)content);
    }
}

