/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.UploadedFile;
import fitnesse.responders.files.UploadResponder;
import fitnesse.testutil.FitNesseUtil;
import java.io.File;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UploadResponderTest
extends TestCase {
    private FitNesseContext context;
    private UploadResponder responder;
    private MockRequest request;
    private File testFile;

    public void setUp() throws Exception {
        this.context = FitNesseUtil.makeTestContext(null);
        FileUtil.makeDir((String)this.context.getRootPagePath());
        FileUtil.makeDir((String)(this.context.getRootPagePath() + "/files"));
        this.testFile = FileUtil.createFile((String)(this.context.getRootPagePath() + "/tempFile.txt"), (String)"test content");
        this.responder = new UploadResponder();
        this.request = new MockRequest();
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)this.context.getRootPagePath());
    }

    public void testMakeResponse() throws Exception {
        this.request.addInput("file", (Object)new UploadedFile("sourceFilename.txt", "plain/text", this.testFile));
        this.request.setResource("files/");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        File file = new File(this.context.getRootPagePath() + "/files/sourceFilename.txt");
        UploadResponderTest.assertTrue((boolean)file.exists());
        UploadResponderTest.assertEquals((String)"test content", (String)FileUtil.getFileContent((File)file));
        UploadResponderTest.assertEquals((int)303, (int)response.getStatus());
        UploadResponderTest.assertEquals((String)"/files/", (String)response.getHeader("Location"));
    }

    public void testMakeResponseSpaceInFileName() throws Exception {
        this.request.addInput("file", (Object)new UploadedFile("source filename.txt", "plain/text", this.testFile));
        this.request.setResource("files/");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        File file = new File(this.context.getRootPagePath() + "/files/source filename.txt");
        UploadResponderTest.assertTrue((boolean)file.exists());
        UploadResponderTest.assertEquals((String)"test content", (String)FileUtil.getFileContent((File)file));
        UploadResponderTest.assertEquals((int)303, (int)response.getStatus());
        UploadResponderTest.assertEquals((String)"/files/", (String)response.getHeader("Location"));
    }

    public void testMakeResponseSpaceInDirectoryName() throws Exception {
        FileUtil.makeDir((String)(this.context.getRootPagePath() + "/files/Folder With Space"));
        this.request.addInput("file", (Object)new UploadedFile("filename.txt", "plain/text", this.testFile));
        this.request.setResource("files/Folder%20With%20Space/");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        File file = new File(this.context.getRootPagePath() + "/files/Folder With Space/filename.txt");
        UploadResponderTest.assertTrue((boolean)file.exists());
        UploadResponderTest.assertEquals((String)"test content", (String)FileUtil.getFileContent((File)file));
        UploadResponderTest.assertEquals((int)303, (int)response.getStatus());
        UploadResponderTest.assertEquals((String)"/files/Folder%20With%20Space/", (String)response.getHeader("Location"));
    }

    public void testMakeRelativeFilename() throws Exception {
        String name1 = "name1.txt";
        String name2 = "name2";
        String name3 = "C:\\folder\\name3.txt";
        String name4 = "/home/user/name4.txt";
        UploadResponderTest.assertEquals((String)"name1.txt", (String)UploadResponder.makeRelativeFilename((String)name1));
        UploadResponderTest.assertEquals((String)"name2", (String)UploadResponder.makeRelativeFilename((String)name2));
        UploadResponderTest.assertEquals((String)"name3.txt", (String)UploadResponder.makeRelativeFilename((String)name3));
        UploadResponderTest.assertEquals((String)"name4.txt", (String)UploadResponder.makeRelativeFilename((String)name4));
    }

    public void testMakeNewFilename() throws Exception {
        UploadResponderTest.assertEquals((String)"file_copy1.txt", (String)UploadResponder.makeNewFilename((String)"file.txt", (int)1));
        UploadResponderTest.assertEquals((String)"file_copy2.txt", (String)UploadResponder.makeNewFilename((String)"file.txt", (int)2));
        UploadResponderTest.assertEquals((String)"a.b.c.d_copy2.txt", (String)UploadResponder.makeNewFilename((String)"a.b.c.d.txt", (int)2));
        UploadResponderTest.assertEquals((String)"somefile_copy1", (String)UploadResponder.makeNewFilename((String)"somefile", (int)1));
    }

    public void testWriteFile() throws Exception {
        File file = new File(this.context.getRootPagePath() + "/testFile");
        File inputFile = FileUtil.createFile((String)(this.context.getRootPagePath() + "/testInput"), (String)"heres the content");
        UploadedFile uploaded = new UploadedFile(this.context.getRootPagePath() + "/testOutput", "text", inputFile);
        long inputFileLength = inputFile.length();
        String inputFileContent = FileUtil.getFileContent((File)inputFile);
        this.responder.writeFile(file, uploaded);
        UploadResponderTest.assertEquals((long)inputFileLength, (long)file.length());
        UploadResponderTest.assertEquals((String)inputFileContent, (String)FileUtil.getFileContent((File)file));
    }
}

