/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.components.PageReferenceRenamer;
import fitnesse.components.ReferenceRenamer;
import fitnesse.http.Request;
import fitnesse.responders.refactoring.PageMovementResponder;
import fitnesse.responders.refactoring.RefactorException;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.WikiWordPath;

public class RenamePageResponder
extends PageMovementResponder {
    private String newName;

    protected boolean getAndValidateNewParentPage(FitNesseContext context, Request request) {
        this.newParentPath = PathParser.parse((String)this.oldNameOfPageToBeMoved).parentPath();
        this.newParentPage = this.oldRefactoredPage.getParent();
        return this.newParentPage != null;
    }

    protected boolean getAndValidateRefactoringParameters(Request request) {
        this.newName = (String)request.getInput("newName");
        return this.newName != null && WikiWordPath.isSingleWikiWord((String)this.newName) && !"FrontPage".equals(this.oldNameOfPageToBeMoved);
    }

    protected ReferenceRenamer getReferenceRenamer(FitNesseContext context) {
        return new PageReferenceRenamer(context.root, this.oldRefactoredPage, this.getNewPageName());
    }

    protected void execute() throws RefactorException {
        WikiPage parentOfPageToRename = this.oldRefactoredPage.getParent();
        this.movePage(this.oldRefactoredPage, parentOfPageToRename, this.newName);
    }

    protected String getNewPageName() {
        return this.newName;
    }

    protected String getErrorMessageHeader() {
        return "Cannot rename " + this.makeLink(this.oldNameOfPageToBeMoved) + " to " + this.newName;
    }
}

