/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.FitProtocol;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.SocketDealer;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.PuppetResponse;
import fitnesse.responders.run.ResponsePuppeteer;
import fitnesse.testsystems.fit.SocketDoner;
import java.io.OutputStream;
import java.net.Socket;

public class SocketCatchingResponder
implements Responder,
SocketDoner,
ResponsePuppeteer {
    private int ticketNumber;
    private SocketDealer dealer;
    private Socket socket;
    private ResponseSender sender;
    private PuppetResponse response;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.dealer = context.socketDealer;
        this.ticketNumber = Integer.parseInt(request.getInput("ticket").toString());
        this.response = new PuppetResponse((ResponsePuppeteer)this);
        return this.response;
    }

    public void readyToSend(ResponseSender sender) {
        this.socket = sender.getSocket();
        this.sender = sender;
        try {
            if (this.dealer.isWaiting(this.ticketNumber)) {
                this.dealer.dealSocketTo(this.ticketNumber, (SocketDoner)this);
            } else {
                String errorMessage = "There are no clients waiting for a socket with ticketNumber " + this.ticketNumber;
                FitProtocol.writeData((String)errorMessage, (OutputStream)this.socket.getOutputStream());
                this.response.setStatus(404);
                sender.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Socket donateSocket() {
        return this.socket;
    }

    public void finishedWithSocket() {
        this.sender.close();
    }
}

