/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.run.StopTestResponder;
import fitnesse.responders.run.StopTestResponderTest;
import fitnesse.responders.run.Stoppable;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class StopTestResponderTest {
    private Request request = null;
    private FitNesseContext context = null;
    private StoppedRecorder stoppableA = new StoppedRecorder(this);
    private StoppedRecorder stoppableB = new StoppedRecorder(this);

    @Before
    public void setUp() throws Exception {
        this.request = new MockRequest();
        this.context = FitNesseUtil.makeTestContext((WikiPage)InMemoryPage.makeRoot((String)"RooT"));
    }

    @Test
    public void testStopAll() throws Exception {
        this.context.runningTestingTracker.addStartedProcess((Stoppable)this.stoppableA);
        this.context.runningTestingTracker.addStartedProcess((Stoppable)this.stoppableB);
        StopTestResponder stopResponder = new StopTestResponder();
        String response = this.runResponder(stopResponder);
        Assert.assertTrue((boolean)this.stoppableA.wasStopped());
        Assert.assertTrue((boolean)this.stoppableB.wasStopped());
        RegexTestCase.assertSubString((String)"all", (String)response);
        RegexTestCase.assertSubString((String)"2", (String)response);
    }

    @Test
    public void testStopB() throws Exception {
        this.context.runningTestingTracker.addStartedProcess((Stoppable)this.stoppableA);
        String bId = this.context.runningTestingTracker.addStartedProcess((Stoppable)this.stoppableB);
        this.request = new /* Unavailable Anonymous Inner Class!! */;
        StopTestResponder stopResponder = new StopTestResponder();
        String response = this.runResponder(stopResponder);
        Assert.assertFalse((boolean)this.stoppableA.wasStopped());
        Assert.assertTrue((boolean)this.stoppableB.wasStopped());
        RegexTestCase.assertSubString((String)"Stopped 1 test", (String)response);
    }

    private String runResponder(StopTestResponder responder) throws Exception {
        Response response = responder.makeResponse(this.context, this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        String results = sender.sentData();
        return results;
    }
}

