/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import util.Clock;
import util.TestClock;
import util.TimeMeasurement;

public class SuiteExecutionReportFormatterTest {
    @Test
    public void testCompleteShouldSetRunTimeForCurrentReference() throws Exception {
        FitNesseContext context = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        TestPage page = new TestPage((WikiPage)new WikiPageDummy("name", "content"));
        SuiteExecutionReportFormatter formatter = new SuiteExecutionReportFormatter(context, page.getSourcePage());
        TimeMeasurement timeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)timeMeasurement.startedAt()).thenReturn((Object)65L);
        Mockito.when((Object)timeMeasurement.elapsed()).thenReturn((Object)2L);
        formatter.newTestStarted(page, timeMeasurement);
        Mockito.when((Object)timeMeasurement.elapsed()).thenReturn((Object)99L);
        TestSummary testSummary = new TestSummary(4, 2, 7, 3);
        formatter.testComplete(page, testSummary, timeMeasurement);
        Assert.assertThat((Object)formatter.suiteExecutionReport.getPageHistoryReferences().size(), (Matcher)CoreMatchers.is((Object)1));
        SuiteExecutionReport.PageHistoryReference reference = (SuiteExecutionReport.PageHistoryReference)formatter.suiteExecutionReport.getPageHistoryReferences().get(0);
        Assert.assertThat((Object)reference.getTestSummary(), (Matcher)CoreMatchers.equalTo((Object)testSummary));
        Assert.assertThat((Object)reference.getRunTimeInMillis(), (Matcher)CoreMatchers.is((Object)99L));
    }

    @Test
    public void allTestingCompleteShouldSetTotalRunTimeOnReport() throws Exception {
        FitNesseContext context = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        WikiPageDummy page = new WikiPageDummy("name", "content");
        SuiteExecutionReportFormatter formatter = new SuiteExecutionReportFormatter(context, (WikiPage)page);
        TestClock clock = new TestClock();
        clock.currentTime = 100L;
        TimeMeasurement totalTimeMeasurement = new TimeMeasurement((Clock)clock).start();
        formatter.announceNumberTestsToRun(0);
        clock.currentTime = 150L;
        formatter.allTestingComplete(totalTimeMeasurement);
        Assert.assertThat((Object)formatter.suiteExecutionReport.getTotalRunTimeInMillis(), (Matcher)CoreMatchers.is((Object)totalTimeMeasurement.elapsed()));
    }

    @Test
    public void testCompleteShouldSetFailedCount() throws Exception {
        FitNesseContext context = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        TestPage page = new TestPage((WikiPage)new WikiPageDummy("name", "content"));
        SuiteExecutionReportFormatter formatter = new SuiteExecutionReportFormatter(context, page.getSourcePage());
        TimeMeasurement timeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)timeMeasurement.startedAt()).thenReturn((Object)65L);
        Mockito.when((Object)timeMeasurement.elapsed()).thenReturn((Object)2L);
        formatter.newTestStarted(page, timeMeasurement);
        Mockito.when((Object)timeMeasurement.elapsed()).thenReturn((Object)99L);
        TestSummary testSummary = new TestSummary(4, 2, 7, 3);
        formatter.testComplete(page, testSummary, timeMeasurement);
        Assert.assertThat((Object)formatter.failCount, (Matcher)CoreMatchers.is((Object)5));
        formatter.allTestingComplete(timeMeasurement);
        Assert.assertThat((Object)BaseFormatter.finalErrorCount, (Matcher)CoreMatchers.is((Object)5));
    }
}

