/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.formatters.SuiteHistoryFormatter;
import fitnesse.responders.run.formatters.SuiteHistoryFormatterTest;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.DateTimeUtil;
import util.TimeMeasurement;
import util.XmlUtil;

public class SuiteHistoryFormatterTest {
    private SuiteHistoryFormatter formatter;
    private WikiPage root;
    private FitNesseContext context;
    private TestPage testPage;
    private StringWriter writer;
    private long testTime;
    private WikiPage suitePage;

    @Before
    public void setup() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.suitePage = this.root.addChildPage("SuitePage");
        this.testPage = new TestPage(this.suitePage.addChildPage("TestPage"));
        this.writer = new StringWriter();
        this.formatter = new SuiteHistoryFormatter(this.context, this.suitePage, (Writer)this.writer);
        this.testTime = DateTimeUtil.getTimeFromString((String)"12/5/1952 1:19:00");
    }

    @Test
    public void shouldRememberTestSummariesInReferences() throws Exception {
        TimeMeasurement totalTimeMeasurement = new TimeMeasurement().start();
        this.performTest(totalTimeMeasurement);
        List references = this.formatter.getPageHistoryReferences();
        Assert.assertEquals((long)1L, (long)references.size());
        SuiteExecutionReport.PageHistoryReference pageHistoryReference = (SuiteExecutionReport.PageHistoryReference)references.get(0);
        Assert.assertEquals((Object)new TestSummary(1, 2, 3, 4), (Object)pageHistoryReference.getTestSummary());
        Assert.assertEquals((long)13L, (long)pageHistoryReference.getRunTimeInMillis());
    }

    private void performTest(TimeMeasurement totalTimeMeasurement) throws Exception {
        this.formatter.announceNumberTestsToRun(1);
        while (totalTimeMeasurement.elapsed() == 0L) {
            Thread.sleep(50L);
        }
        1 testTimeMeasurement = new /* Unavailable Anonymous Inner Class!! */;
        this.formatter.newTestStarted(this.testPage, (TimeMeasurement)testTimeMeasurement);
        this.formatter.testComplete(this.testPage, new TestSummary(1, 2, 3, 4), (TimeMeasurement)testTimeMeasurement);
        this.formatter.allTestingComplete(totalTimeMeasurement.stop());
    }

    @Test
    public void allTestingCompleteShouldProduceLinksAndSetTotalRunTimeOnReport() throws Exception {
        TimeMeasurement totalTimeMeasurement = new TimeMeasurement().start();
        this.performTest(totalTimeMeasurement);
        Assert.assertEquals((long)totalTimeMeasurement.elapsed(), (long)this.formatter.suiteExecutionReport.getTotalRunTimeInMillis());
        String output = this.writer.toString();
        Document document = XmlUtil.newDocument((String)output);
        Element suiteResultsElement = document.getDocumentElement();
        Assert.assertEquals((Object)"suiteResults", (Object)suiteResultsElement.getNodeName());
        Assert.assertEquals((Object)new FitNesseVersion().toString(), (Object)XmlUtil.getTextValue((Element)suiteResultsElement, (String)"FitNesseVersion"));
        Assert.assertEquals((Object)"SuitePage", (Object)XmlUtil.getTextValue((Element)suiteResultsElement, (String)"rootPath"));
        NodeList xmlPageReferences = suiteResultsElement.getElementsByTagName("pageHistoryReference");
        Assert.assertEquals((long)1L, (long)xmlPageReferences.getLength());
        for (int referenceIndex = 0; referenceIndex < xmlPageReferences.getLength(); ++referenceIndex) {
            Element pageHistoryReferenceElement = (Element)xmlPageReferences.item(referenceIndex);
            Assert.assertEquals((Object)"SuitePage.TestPage", (Object)XmlUtil.getTextValue((Element)pageHistoryReferenceElement, (String)"name"));
            Assert.assertEquals((Object)DateTimeUtil.formatDate((Date)new Date(this.testTime)), (Object)XmlUtil.getTextValue((Element)pageHistoryReferenceElement, (String)"date"));
            String link = "SuitePage.TestPage?pageHistory&resultDate=19521205011900";
            Assert.assertEquals((Object)link, (Object)XmlUtil.getTextValue((Element)pageHistoryReferenceElement, (String)"pageHistoryLink"));
            Element countsElement = XmlUtil.getElementByTagName((Element)pageHistoryReferenceElement, (String)"counts");
            Assert.assertEquals((Object)"1", (Object)XmlUtil.getTextValue((Element)countsElement, (String)"right"));
            Assert.assertEquals((Object)"2", (Object)XmlUtil.getTextValue((Element)countsElement, (String)"wrong"));
            Assert.assertEquals((Object)"3", (Object)XmlUtil.getTextValue((Element)countsElement, (String)"ignores"));
            Assert.assertEquals((Object)"4", (Object)XmlUtil.getTextValue((Element)countsElement, (String)"exceptions"));
            Assert.assertEquals((Object)"13", (Object)XmlUtil.getTextValue((Element)pageHistoryReferenceElement, (String)"runTimeInMillis"));
        }
        Element finalCounts = XmlUtil.getElementByTagName((Element)suiteResultsElement, (String)"finalCounts");
        Assert.assertEquals((Object)"0", (Object)XmlUtil.getTextValue((Element)finalCounts, (String)"right"));
        Assert.assertEquals((Object)"1", (Object)XmlUtil.getTextValue((Element)finalCounts, (String)"wrong"));
        Assert.assertEquals((Object)"0", (Object)XmlUtil.getTextValue((Element)finalCounts, (String)"ignores"));
        Assert.assertEquals((Object)"0", (Object)XmlUtil.getTextValue((Element)finalCounts, (String)"exceptions"));
        Assert.assertEquals((Object)String.valueOf(totalTimeMeasurement.elapsed()), (Object)XmlUtil.getTextValue((Element)suiteResultsElement, (String)"totalRunTimeInMillis"));
    }

    static /* synthetic */ long access$000(SuiteHistoryFormatterTest x0) {
        return x0.testTime;
    }
}

