/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.http.ChunkedResponse;
import fitnesse.responders.run.formatters.TestTextFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import java.text.SimpleDateFormat;
import org.junit.Test;
import org.mockito.Mockito;
import util.TimeMeasurement;

public class TestTextFormatterTest {
    @Test
    public void testCompleteShouldAddPageAndSummaryAndTimingToResponse() throws Exception {
        TestPage page = new TestPage((WikiPage)new WikiPageDummy("page", "content"));
        TestSummary summary = new TestSummary(1, 2, 3, 4);
        TimeMeasurement timeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        String startTime = "11:12:13";
        Mockito.when((Object)timeMeasurement.startedAtDate()).thenReturn((Object)new SimpleDateFormat("HH:mm:ss").parse(startTime));
        Mockito.when((Object)timeMeasurement.elapsedSeconds()).thenReturn((Object)9.8);
        ChunkedResponse response = (ChunkedResponse)Mockito.mock(ChunkedResponse.class);
        TestTextFormatter formatter = new TestTextFormatter(response);
        formatter.testComplete(page, summary, timeMeasurement);
        ((ChunkedResponse)Mockito.verify((Object)response)).add("F " + startTime + " R:1    W:2    I:3    E:4    page\t()\t9.800 seconds\n");
    }

    @Test
    public void allTestingCompleteShouldAddTotalsToResponse() throws Exception {
        TimeMeasurement mockTimeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)mockTimeMeasurement.elapsedSeconds()).thenReturn((Object)7.6);
        ChunkedResponse response = (ChunkedResponse)Mockito.mock(ChunkedResponse.class);
        TestTextFormatter formatter = new TestTextFormatter(response);
        formatter.allTestingComplete(mockTimeMeasurement);
        ((ChunkedResponse)Mockito.verify((Object)response)).add("--------\n0 Tests,\t0 Failures\t7.600 seconds.\n");
    }
}

