/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.responders.run.formatters.XmlFormatterTest;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import java.text.ParseException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.Clock;
import util.DateAlteringClock;
import util.DateTimeUtil;
import util.TimeMeasurement;

public class XmlFormatterTest {
    private static final String TEST_TIME = "4/13/2009 15:21:43";
    private DateAlteringClock clock;

    @Before
    public void setUp() throws ParseException {
        this.clock = new DateAlteringClock(DateTimeUtil.getDateFromString((String)TEST_TIME)).freeze();
    }

    @After
    public void tearDown() {
        Clock.restoreDefaultClock();
    }

    @Test
    public void makeFileName() throws Exception {
        TestSummary summary = new TestSummary(1, 2, 3, 4);
        Assert.assertEquals((Object)"20090413152143_1_2_3_4.xml", (Object)TestHistory.makeResultFileName((TestSummary)summary, (long)this.clock.currentClockTimeInMillis()));
    }

    @Test
    public void processTestResultsShouldBuildUpCurrentResultAndFinalSummary() throws Exception {
        FitNesseContext context = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        TestPage page = new TestPage((WikiPage)new WikiPageDummy("name", "content"));
        page.getData().setAttribute("Suites", "tag1");
        XmlFormatter.WriterFactory writerFactory = (XmlFormatter.WriterFactory)Mockito.mock(XmlFormatter.WriterFactory.class);
        TestExecutionReport.TestResult testResult = new TestExecutionReport.TestResult();
        1 formatter = new /* Unavailable Anonymous Inner Class!! */;
        formatter.testOutputChunk("outputChunk");
        TimeMeasurement timeMeasurement = new /* Unavailable Anonymous Inner Class!! */.start();
        formatter.newTestStarted(page, timeMeasurement);
        TestSummary summary = new TestSummary(9, 8, 7, 6);
        formatter.testComplete(page, summary, timeMeasurement);
        Assert.assertThat((Object)formatter.finalSummary, (Matcher)CoreMatchers.equalTo((Object)summary));
        Assert.assertThat((Object)formatter.testResponse.results.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(formatter.testResponse.results.get(0), (Matcher)CoreMatchers.is((Object)testResult));
        Assert.assertThat((Object)testResult.startTime, (Matcher)CoreMatchers.is((Object)timeMeasurement.startedAt()));
        Assert.assertThat((Object)testResult.content, (Matcher)CoreMatchers.is((Object)"outputChunk"));
        Assert.assertThat((Object)testResult.right, (Matcher)CoreMatchers.is((Object)"9"));
        Assert.assertThat((Object)testResult.wrong, (Matcher)CoreMatchers.is((Object)"8"));
        Assert.assertThat((Object)testResult.ignores, (Matcher)CoreMatchers.is((Object)"7"));
        Assert.assertThat((Object)testResult.exceptions, (Matcher)CoreMatchers.is((Object)"6"));
        Assert.assertThat((Object)testResult.runTimeInMillis, (Matcher)CoreMatchers.is((Object)"27"));
        Assert.assertThat((Object)testResult.relativePageName, (Matcher)CoreMatchers.is((Object)page.getName()));
        Assert.assertThat((Object)testResult.tags, (Matcher)CoreMatchers.is((Object)"tag1"));
    }

    @Test
    public void allTestingCompleteShouldSetTotalRunTime() throws Exception {
        FitNesseContext context = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        WikiPageDummy page = new WikiPageDummy("name", "content");
        XmlFormatter.WriterFactory writerFactory = (XmlFormatter.WriterFactory)Mockito.mock(XmlFormatter.WriterFactory.class);
        3 formatter = new /* Unavailable Anonymous Inner Class!! */;
        TimeMeasurement totalTimeMeasurement = (TimeMeasurement)Mockito.mock(TimeMeasurement.class);
        Mockito.when((Object)totalTimeMeasurement.elapsed()).thenReturn((Object)77L);
        formatter.allTestingComplete(totalTimeMeasurement);
        Assert.assertThat((Object)formatter.testResponse.getTotalRunTimeInMillis(), (Matcher)CoreMatchers.is((Object)77L));
    }
}

