/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.components.RegularExpressionWikiPageFinder;
import fitnesse.components.TitleWikiPageFinder;
import fitnesse.components.TraversalListener;
import fitnesse.responders.search.ResultResponder;
import java.util.regex.Pattern;

public class SearchResponder
extends ResultResponder {
    private String getSearchString() {
        return (String)this.request.getInput("searchString");
    }

    private String getSearchType() {
        String searchType = (String)this.request.getInput("searchType");
        if (searchType == null || searchType.toLowerCase().contains("title")) {
            return "Title";
        }
        return "Content";
    }

    protected String getPageFooterInfo(int hits) {
        return "Found " + hits + " results for your search.";
    }

    protected String getTitle() {
        return this.getSearchType() + " Search Results for '" + this.getSearchString() + "'";
    }

    public void traverse(TraversalListener<Object> observer) {
        String searchString = this.getSearchString();
        if (!"".equals(searchString)) {
            String searchType = this.getSearchType();
            if ("Title".equals(searchType)) {
                new TitleWikiPageFinder(searchString, observer).search(this.root);
            } else {
                Pattern regularExpression = Pattern.compile(searchString, 18);
                new RegularExpressionWikiPageFinder(regularExpression, observer).search(this.root);
            }
        }
    }

    protected boolean shouldRespondWith404() {
        return false;
    }
}

