/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.Clock;
import util.FileUtil;

public class PurgeHistoryResponder
implements SecureResponder {
    private File resultsDirectory;
    private Date todaysDate;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.initializeResponder(context);
        if (this.hasValidInputs(request)) {
            this.purgeHistory(request);
            return this.makeValidResponse();
        }
        return this.makeErrorResponse(context, request);
    }

    private void initializeResponder(FitNesseContext context) {
        if (this.resultsDirectory == null) {
            this.resultsDirectory = context.getTestHistoryDirectory();
        }
        this.todaysDate = Clock.currentDate();
    }

    private SimpleResponse makeValidResponse() {
        SimpleResponse response = new SimpleResponse();
        response.redirect("?testHistory");
        return response;
    }

    private void purgeHistory(Request request) {
        int days = this.getDaysInput(request);
        this.deleteTestHistoryOlderThanDays(days);
    }

    private Integer getDaysInput(Request request) {
        String daysInput = request.getInput("days").toString();
        return this.parseInt(daysInput);
    }

    private Integer parseInt(String daysInput) {
        try {
            return Integer.parseInt(daysInput);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private boolean hasValidInputs(Request request) {
        return request.getInput("days") != null && this.getDaysInput(request) >= 0;
    }

    private Response makeErrorResponse(FitNesseContext context, Request request) {
        return new ErrorResponder("Invalid Amount Of Days").makeResponse(context, request);
    }

    public void setResultsDirectory(File directory) {
        this.resultsDirectory = directory;
    }

    public void setTodaysDate(Date date) {
        this.todaysDate = new Date(date.getTime());
    }

    public void deleteTestHistoryOlderThanDays(int days) {
        Date expirationDate = this.getDateDaysAgo(days);
        File[] files = FileUtil.getDirectoryListing((File)this.resultsDirectory);
        this.deleteExpiredFiles(files, expirationDate);
    }

    private void deleteExpiredFiles(File[] files, Date expirationDate) {
        for (File file : files) {
            this.deleteIfExpired(file, expirationDate);
        }
    }

    public Date getDateDaysAgo(int days) {
        long now = this.todaysDate.getTime();
        long millisecondsPerDay = 86400000L;
        Date daysEarlier = new Date(now - millisecondsPerDay * (long)days);
        return daysEarlier;
    }

    private void deleteIfExpired(File file, Date expirationDate) {
        if (file.isDirectory()) {
            this.deleteDirectoryIfExpired(file, expirationDate);
        } else {
            this.deleteFileIfExpired(file, expirationDate);
        }
    }

    private void deleteDirectoryIfExpired(File file, Date expirationDate) {
        File[] files = FileUtil.getDirectoryListing((File)file);
        this.deleteExpiredFiles(files, expirationDate);
        if (file.list().length == 0) {
            FileUtil.deleteFileSystemDirectory((File)file);
        }
    }

    private void deleteFileIfExpired(File file, Date purgeOlder) {
        String name = file.getName();
        Date date = this.getDateFromPageHistoryFileName(name);
        if (date.getTime() < purgeOlder.getTime()) {
            FileUtil.deleteFile((File)file);
        }
    }

    private Date getDateFromPageHistoryFileName(String name) {
        try {
            return this.tryExtractDateFromTestHistoryName(name);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Date tryExtractDateFromTestHistoryName(String testHistoryName) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = testHistoryName.split("_")[0];
        return dateFormat.parse(dateString);
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

