/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.components.ContentBuffer;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.runner.ResultHandler;
import fitnesse.testsystems.TestSummary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachingResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    public List<ResultHandler> subHandlers = new LinkedList();

    public CachingResultFormatter() throws IOException {
        this.buffer = new ContentBuffer(".results");
    }

    public void acceptResult(PageResult result) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FitProtocol.writeData((String)(result.toString() + "\n"), (OutputStream)output);
        this.buffer.append(output.toByteArray());
        Iterator iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            ((ResultHandler)iterator.next()).acceptResult(result);
        }
    }

    public void acceptFinalCount(TestSummary testSummary) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Counts counts = new Counts(testSummary.getRight(), testSummary.getWrong(), testSummary.getIgnores(), testSummary.getExceptions());
        FitProtocol.writeCounts((Counts)counts, (OutputStream)output);
        this.buffer.append(output.toByteArray());
        Iterator iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            ((ResultHandler)iterator.next()).acceptFinalCount(testSummary);
        }
    }

    public int getByteCount() {
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws IOException {
        return this.buffer.getNonDeleteingInputStream();
    }

    public void cleanUp() {
        this.buffer.delete();
    }

    public void addHandler(ResultHandler handler) {
        this.subHandlers.add(handler);
    }
}

