/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.testsystems.TestSummary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageResult {
    private static final Pattern countsPattern = Pattern.compile("(\\d+)[^,]*, (\\d+)[^,]*, (\\d+)[^,]*, (\\d+)[^,]*");
    private StringBuffer contentBuffer = new StringBuffer();
    private TestSummary testSummary;
    private String title;

    public PageResult(String title) {
        this.title = title;
    }

    public PageResult(String title, TestSummary testSummary, String startingContent) throws Exception {
        this(title);
        this.testSummary = testSummary;
        this.append(startingContent);
    }

    public String content() {
        return this.contentBuffer.toString();
    }

    public void append(String data) throws Exception {
        this.contentBuffer.append(data);
    }

    public String title() {
        return this.title;
    }

    public TestSummary testSummary() {
        return this.testSummary;
    }

    public void setTestSummary(TestSummary testSummary) {
        this.testSummary = testSummary;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.title).append("\n");
        buffer.append(this.testSummary.toString()).append("\n");
        buffer.append(this.contentBuffer);
        return buffer.toString();
    }

    public static PageResult parse(String resultString) throws Exception {
        int firstEndlIndex = resultString.indexOf(10);
        int secondEndlIndex = resultString.indexOf(10, firstEndlIndex + 1);
        String title = resultString.substring(0, firstEndlIndex);
        TestSummary testSummary = PageResult.parseCounts((String)resultString.substring(firstEndlIndex + 1, secondEndlIndex));
        String content = resultString.substring(secondEndlIndex + 1);
        return new PageResult(title, testSummary, content);
    }

    private static TestSummary parseCounts(String countString) {
        Matcher matcher = countsPattern.matcher(countString);
        if (matcher.find()) {
            int right = Integer.parseInt(matcher.group(1));
            int wrong = Integer.parseInt(matcher.group(2));
            int ignores = Integer.parseInt(matcher.group(3));
            int exceptions = Integer.parseInt(matcher.group(4));
            return new TestSummary(right, wrong, ignores, exceptions);
        }
        return null;
    }
}

