/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.runner.PageResult;
import fitnesse.runner.XmlResultFormatter;
import fitnesse.testsystems.TestSummary;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.RegexTestCase;
import util.StreamReader;
import util.XmlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlResultFormatterTest
extends RegexTestCase {
    private XmlResultFormatter formatter;
    private PageResult result1;
    private PageResult result2;
    private TestSummary finalSummary;

    public void setUp() throws Exception {
        this.formatter = new XmlResultFormatter("localhost:8081", "RootPath");
        this.result1 = new PageResult("ResultOne", new TestSummary(1, 2, 3, 4), "result one content");
        this.result2 = new PageResult("ResultTwo", new TestSummary(4, 3, 2, 1), "result two content");
        this.finalSummary = new TestSummary(5, 5, 5, 5);
    }

    public void tearDown() throws Exception {
        this.formatter = null;
    }

    public void testValidXml() throws Exception {
        Document doc = this.getXmlDoc();
        Element documentElement = doc.getDocumentElement();
        XmlResultFormatterTest.assertEquals((String)"testResults", (String)documentElement.getNodeName());
        XmlResultFormatterTest.assertEquals((String)"localhost:8081", (String)XmlUtil.getTextValue((Element)documentElement, (String)"host"));
        XmlResultFormatterTest.assertEquals((String)"RootPath", (String)XmlUtil.getTextValue((Element)documentElement, (String)"rootPath"));
    }

    public void testOneResult() throws Exception {
        this.formatter.acceptResult(this.result1);
        Document doc = this.getXmlDoc();
        NodeList results = doc.getElementsByTagName("result");
        XmlResultFormatterTest.assertEquals((int)1, (int)results.getLength());
        Element result = (Element)results.item(0);
        this.checkResultElement(result, this.result1);
    }

    public void testTwoResults() throws Exception {
        this.formatter.acceptResult(this.result1);
        this.formatter.acceptResult(this.result2);
        Document doc = this.getXmlDoc();
        NodeList results = doc.getElementsByTagName("result");
        XmlResultFormatterTest.assertEquals((int)2, (int)results.getLength());
        Element resultElement1 = (Element)results.item(0);
        Element resultElement2 = (Element)results.item(1);
        this.checkResultElement(resultElement1, this.result1);
        this.checkResultElement(resultElement2, this.result2);
    }

    public void testFinalCounts() throws Exception {
        this.formatter.acceptFinalCount(this.finalSummary);
        Document doc = this.getXmlDoc();
        NodeList finalCountsList = doc.getElementsByTagName("finalCounts");
        XmlResultFormatterTest.assertEquals((int)1, (int)finalCountsList.getLength());
        Element finalCountElement = (Element)finalCountsList.item(0);
        this.checkCounts(this.finalSummary, finalCountElement);
    }

    private void checkResultElement(Element resultElement, PageResult result) throws Exception {
        XmlResultFormatterTest.assertEquals((String)result.title(), (String)XmlUtil.getTextValue((Element)resultElement, (String)"relativePageName"));
        XmlResultFormatterTest.assertEquals((String)result.content(), (String)XmlUtil.getTextValue((Element)resultElement, (String)"content"));
        Element countsElement = XmlUtil.getElementByTagName((Element)resultElement, (String)"counts");
        TestSummary testSummary = result.testSummary();
        this.checkCounts(testSummary, countsElement);
    }

    private void checkCounts(TestSummary testSummary, Element countsElement) throws Exception {
        XmlResultFormatterTest.assertEquals((String)(testSummary.getRight() + ""), (String)XmlUtil.getTextValue((Element)countsElement, (String)"right"));
        XmlResultFormatterTest.assertEquals((String)(testSummary.getWrong() + ""), (String)XmlUtil.getTextValue((Element)countsElement, (String)"wrong"));
        XmlResultFormatterTest.assertEquals((String)(testSummary.getIgnores() + ""), (String)XmlUtil.getTextValue((Element)countsElement, (String)"ignores"));
        XmlResultFormatterTest.assertEquals((String)(testSummary.getExceptions() + ""), (String)XmlUtil.getTextValue((Element)countsElement, (String)"exceptions"));
    }

    private String getXml() throws Exception {
        InputStream input = this.formatter.getResultStream();
        XmlResultFormatterTest.assertNotNull((Object)input);
        int bytes = this.formatter.getByteCount();
        String xml = new StreamReader(input).read(bytes);
        return xml;
    }

    private Document getXmlDoc() throws Exception {
        return XmlUtil.newDocument((String)this.getXml());
    }
}

