/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.slim.SlimServiceTestBase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SlimServiceTest
extends SlimServiceTestBase {
    protected String getImport() {
        return "fitnesse.slim.test";
    }

    protected void startSlimService() throws IOException {
        SlimService.parseCommandLine((String[])new String[]{"8099"});
        SlimService.startWithFactoryAsync((SlimFactory)new JavaSlimFactory());
    }

    protected void closeSlimService() throws InterruptedException {
        SlimService.waitForServiceToStopAsync();
        Assert.assertFalse((boolean)SlimService.service.isAlive());
    }

    protected String expectedExceptionMessage() {
        return "java.lang.Exception: This is my exception";
    }

    protected String expectedStopTestExceptionMessage() {
        return "ABORT_SLIM_TEST:fitnesse.slim.test.TestSlim$StopTestException: This is a stop test exception";
    }

    @Test
    public void nullInteractionService_returnsDefaultClass() {
        SlimService.interactionClassName = null;
        Assert.assertEquals((Object)"fitnesse.slim.fixtureInteraction.DefaultInteraction", (Object)SlimService.getInteractionClass().getName());
    }

    @Test
    public void definedInteractionService_returnsCorrectClass() {
        SlimService.interactionClassName = "fitnesse.slim.fixtureInteraction.InteractionDemo";
        Assert.assertEquals((Object)"fitnesse.slim.fixtureInteraction.InteractionDemo", (Object)SlimService.getInteractionClass().getName());
    }
}

