/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimException;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.StatementExecutorTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class StatementExecutorTestBase {
    protected static final String MESSAGE_NO_METHOD_IN_CLASS = "message:<<NO_METHOD_IN_CLASS %s[%d] %s.>>";
    protected static final String INSTANCE_NAME = "myInstance";
    protected StatementExecutorInterface statementExecutor;
    protected int library = 0;

    protected String voidMessage() {
        return "/__VOID__/";
    }

    protected String echoMethodName() {
        return "echo";
    }

    protected String deleteMethodName() {
        return "delete";
    }

    public abstract void init() throws Exception;

    @Test
    public void shouldCallMethodOnGivenInstanceBeforeTryingToInvokeOnSystemUnderTest() throws Exception {
        MyAnnotatedSystemUnderTestFixture myInstance = this.createAnnotatedFixture();
        Object result = this.statementExecutor.call(INSTANCE_NAME, this.echoMethodName(), new Object[0]);
        Assert.assertEquals((Object)this.voidMessage(), (Object)result);
        Assert.assertTrue((boolean)myInstance.echoCalled());
        Assert.assertFalse((boolean)myInstance.getSystemUnderTest().speakCalled());
    }

    @Test
    public void shouldCallMethodOnFieldAnnotatedWithSystemUnderTestWhenFixtureDoesNotHaveMethod() throws Exception {
        MyAnnotatedSystemUnderTestFixture myFixture = this.createAnnotatedFixture();
        this.executeStatementAndVerifyResultIsVoid();
        Assert.assertFalse((boolean)myFixture.echoCalled());
        Assert.assertTrue((boolean)myFixture.getSystemUnderTest().speakCalled());
    }

    @Test
    public void shouldCallMethodOnFieldNamed_systemUnderTest_WhenFixtureDoesNotHaveMethod() throws Exception {
        FixtureWithNamedSystemUnderTestBase myFixture = this.createNamedFixture();
        this.executeStatementAndVerifyResultIsVoid();
        Assert.assertFalse((boolean)myFixture.echoCalled());
        Assert.assertTrue((boolean)myFixture.getSystemUnderTest().speakCalled());
    }

    @Test
    public void shouldReportMissingMethodOnFixtureClassWhenMethodCanNotBeFoundOnBothFixtureAndSystemUnderTest() throws Exception {
        try {
            this.createAnnotatedFixture();
            String result = (String)this.statementExecutor.call(INSTANCE_NAME, "noSuchMethod", new Object[0]);
            Assert.fail((String)"Executed non-existing method.");
        }
        catch (SlimException e) {
            String expectedErrorMessage = String.format(MESSAGE_NO_METHOD_IN_CLASS, "noSuchMethod", 0, this.annotatedFixtureName());
            Assert.assertTrue((boolean)e.getMessage().contains(expectedErrorMessage));
        }
    }

    @Test
    public void shouldPreferMethodOnFixtureOverMethodOnSystemUnderTest() throws Exception {
        FixtureWithNamedSystemUnderTestBase instance = this.createNamedFixture();
        this.statementExecutor.call(INSTANCE_NAME, this.echoMethodName(), new Object[0]);
        Assert.assertFalse((boolean)instance.getSystemUnderTest().echoCalled());
        Assert.assertTrue((boolean)instance.echoCalled());
    }

    @Test
    public void shouldPreferMethodOnFixtureOverMethodOnLibrary() throws Exception {
        SimpleFixture instance = this.createSimpleFixture();
        EchoSupport echoLibrary = this.createEchoLibrary();
        this.statementExecutor.call(INSTANCE_NAME, this.echoMethodName(), new Object[0]);
        Assert.assertFalse((boolean)echoLibrary.echoCalled());
        Assert.assertTrue((boolean)instance.echoCalled());
    }

    @Test
    public void shouldPreferMethodOnSystemUnderTestOverMethodOnLibrary() throws Exception {
        FixtureWithNamedSystemUnderTestBase instance = this.createNamedFixture();
        EchoSupport echoLibrary = this.createEchoLibrary();
        this.statementExecutor.call(INSTANCE_NAME, "speak", new Object[0]);
        Assert.assertFalse((boolean)echoLibrary.speakCalled());
        Assert.assertTrue((boolean)instance.getSystemUnderTest().speakCalled());
    }

    @Test
    public void shouldPreferMethodsOnLibrariesCreatedLaterOverMethodsOnLibrariesCreatedEarlier() throws Exception {
        this.createSimpleFixture();
        EchoSupport echoLibrary1 = this.createEchoLibrary();
        EchoSupport echoLibrary2 = this.createEchoLibrary();
        EchoSupport echoLibrary3 = this.createEchoLibrary();
        this.statementExecutor.call(INSTANCE_NAME, "speak", new Object[0]);
        Assert.assertFalse((boolean)echoLibrary1.speakCalled());
        Assert.assertFalse((boolean)echoLibrary2.speakCalled());
        Assert.assertTrue((boolean)echoLibrary3.speakCalled());
    }

    @Test
    public void shouldCallMethodOnInstallLibraryWhenMethodIsNotFoundInAFixture_WithSystemUnderTestInFixture() throws Exception {
        this.createNamedFixture();
        FileSupport library = this.createFileSupportLibrary();
        Assert.assertNotNull((Object)library);
        Object result = this.statementExecutor.call(INSTANCE_NAME, this.deleteMethodName(), new Object[]{"filename.txt"});
        Assert.assertEquals((Object)this.voidMessage(), (Object)result);
        Assert.assertTrue((boolean)library.deleteCalled());
    }

    @Test
    public void shouldCallMethodOnInstallLibraryWhenMethodIsNotFoundInAFixture() throws Exception {
        this.createFixtureInstance(this.echoLibraryName());
        FileSupport library = this.createFileSupportLibrary();
        Assert.assertNotNull((Object)library);
        Object result = this.statementExecutor.call(INSTANCE_NAME, this.deleteMethodName(), new Object[]{"filename.txt"});
        Assert.assertEquals((Object)this.voidMessage(), (Object)result);
        Assert.assertTrue((boolean)library.deleteCalled());
    }

    protected MyAnnotatedSystemUnderTestFixture createAnnotatedFixture() throws Exception {
        this.createFixtureInstance(this.annotatedFixtureName());
        return (MyAnnotatedSystemUnderTestFixture)this.getVerifiedInstance();
    }

    protected abstract String annotatedFixtureName();

    protected FixtureWithNamedSystemUnderTestBase createNamedFixture() throws Exception {
        this.createFixtureInstance(this.namedFixtureName());
        return (FixtureWithNamedSystemUnderTestBase)this.getVerifiedInstance();
    }

    protected abstract String namedFixtureName();

    protected SimpleFixture createSimpleFixture() throws Exception {
        this.createFixtureInstance(this.simpleFixtureName());
        return (SimpleFixture)this.getVerifiedInstance();
    }

    protected abstract String simpleFixtureName();

    protected EchoSupport createEchoLibrary() throws Exception {
        String instanceName = "library" + this.library++;
        this.statementExecutor.create(instanceName, this.echoLibraryName(), new Object[0]);
        return (EchoSupport)this.statementExecutor.getInstance(instanceName);
    }

    protected abstract String echoLibraryName();

    protected FileSupport createFileSupportLibrary() throws Exception {
        String instanceName = "library" + this.library++;
        this.statementExecutor.create(instanceName, this.fileSupportName(), new Object[0]);
        return (FileSupport)this.statementExecutor.getInstance(instanceName);
    }

    protected abstract String fileSupportName();

    protected void createFixtureInstance(String fixtureClass) throws Exception {
        this.statementExecutor.create(INSTANCE_NAME, fixtureClass, new Object[0]);
    }

    protected Echo getVerifiedInstance() {
        Echo myInstance = (Echo)this.statementExecutor.getInstance(INSTANCE_NAME);
        Assert.assertFalse((boolean)myInstance.echoCalled());
        return myInstance;
    }

    protected void executeStatementAndVerifyResultIsVoid() throws Exception {
        Object result = this.statementExecutor.call(INSTANCE_NAME, "speak", new Object[0]);
        Assert.assertEquals((Object)this.voidMessage(), (Object)result);
    }
}

