/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.ExecutionStatus;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class ExecutionLogTest {
    private static final String ErrorLogName = "ErrorLogs";
    private WikiPage testPage;
    private MockCommandRunner runner;
    private ExecutionLog log;
    private WikiPage root;
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.testPage = this.root.addChildPage("TestPage");
        this.runner = new MockCommandRunner("some command", 123);
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.log = new ExecutionLog(this.testPage, (CommandRunner)this.runner);
    }

    @Test
    public void testNoErrrorLogPageToBeginWith() throws Exception {
        Assert.assertFalse((boolean)this.root.hasChildPage(ErrorLogName));
    }

    @Test
    public void testBasicContent() throws Exception {
        String content = this.getGeneratedContent();
        RegexTestCase.assertSubString((String)"'''Command: '''", (String)content);
        RegexTestCase.assertSubString((String)"!-some command-!", (String)content);
        RegexTestCase.assertSubString((String)"'''Exit code: '''", (String)content);
        RegexTestCase.assertSubString((String)"123", (String)content);
        RegexTestCase.assertSubString((String)"'''Date: '''", (String)content);
        RegexTestCase.assertSubString((String)"'''Time elapsed: '''", (String)content);
    }

    @Test
    public void testPageLink() throws Exception {
        String content = this.getGeneratedContent();
        RegexTestCase.assertSubString((String)"|'''Test Page: '''|.TestPage|", (String)content);
    }

    private String getGeneratedContent() throws Exception {
        return this.log.buildLogContent(this.context.pageFactory);
    }

    @Test
    public void testNoExtraLogTextWasGenerated() throws Exception {
        String content = this.getGeneratedContent();
        RegexTestCase.assertNotSubString((String)"Exception", (String)content);
        RegexTestCase.assertNotSubString((String)"Standard Error", (String)content);
        RegexTestCase.assertNotSubString((String)"Standard Output", (String)content);
    }

    @Test
    public void testStdout() throws Exception {
        this.runner.setOutput("standard output that got printed");
        String content = this.getGeneratedContent();
        RegexTestCase.assertSubString((String)"'''Standard Output:'''", (String)content);
        RegexTestCase.assertSubString((String)"standard output that got printed", (String)content);
    }

    @Test
    public void testStderr() throws Exception {
        this.runner.setError("standard error that got printed");
        String content = this.getGeneratedContent();
        RegexTestCase.assertSubString((String)"'''Standard Error:'''", (String)content);
        RegexTestCase.assertSubString((String)"standard error that got printed", (String)content);
    }

    @Test
    public void testException() throws Exception {
        this.log.addException((Throwable)new Exception("I made this"));
        String content = this.getGeneratedContent();
        RegexTestCase.assertSubString((String)"'''Internal Exception:'''", (String)content);
        RegexTestCase.assertSubString((String)"I made this", (String)content);
    }

    @Test
    public void testExecutionReport_Ok() throws Exception {
        WikiPageDummy wikiPageDummy = new WikiPageDummy("This.Is.Not.A.Real.Location");
        MockCommandRunner mockCommandRunner = new MockCommandRunner();
        ExecutionLog executionLog = new ExecutionLog((WikiPage)wikiPageDummy, (CommandRunner)mockCommandRunner);
        ExecutionStatus result = executionLog.exceptionCount() > 0 ? ExecutionStatus.ERROR : (executionLog.hasCapturedOutput() ? ExecutionStatus.OUTPUT : ExecutionStatus.OK);
        Assert.assertSame((Object)ExecutionStatus.OK, (Object)result);
    }

    @Test
    public void testExecutionReport_Output() throws Exception {
        WikiPageDummy wikiPageDummy = new WikiPageDummy("This.Is.Not.A.Real.Location");
        MockCommandRunner mockCommandRunner = new MockCommandRunner();
        mockCommandRunner.setOutput("I wrote something here");
        ExecutionLog executionLog = new ExecutionLog((WikiPage)wikiPageDummy, (CommandRunner)mockCommandRunner);
        ExecutionStatus result = executionLog.exceptionCount() > 0 ? ExecutionStatus.ERROR : (executionLog.hasCapturedOutput() ? ExecutionStatus.OUTPUT : ExecutionStatus.OK);
        Assert.assertSame((Object)ExecutionStatus.OUTPUT, (Object)result);
    }

    @Test
    public void testExecutionReport_Error() throws Exception {
        WikiPageDummy wikiPageDummy = new WikiPageDummy("This.Is.Not.A.Real.Location");
        MockCommandRunner mockCommandRunner = new MockCommandRunner();
        ExecutionLog executionLog = new ExecutionLog((WikiPage)wikiPageDummy, (CommandRunner)mockCommandRunner);
        executionLog.addException((Throwable)new RuntimeException("I messed up"));
        ExecutionStatus result = executionLog.exceptionCount() > 0 ? ExecutionStatus.ERROR : (executionLog.hasCapturedOutput() ? ExecutionStatus.OUTPUT : ExecutionStatus.OK);
        Assert.assertSame((Object)ExecutionStatus.ERROR, (Object)result);
    }
}

