/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.responders.PageFactory;
import fitnesse.testsystems.ExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TestSystem
implements TestSystemListener {
    public static final String DEFAULT_COMMAND_PATTERN = "java -cp " + TestSystem.fitnesseJar((String)System.getProperty("java.class.path")) + System.getProperty("path.separator") + "%p %m";
    public static final String DEFAULT_JAVA_DEBUG_COMMAND = "java -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000 -cp %p %m";
    public static final String DEFAULT_CSHARP_DEBUG_RUNNER_FIND = "runner.exe";
    public static final String DEFAULT_CSHARP_DEBUG_RUNNER_REPLACE = "runnerw.exe";
    protected final WikiPage page;
    protected final TestSystemListener testSystemListener;
    protected boolean fastTest;
    protected boolean manualStart;
    private ExecutionLog log;

    protected static String fitnesseJar(String classpath) {
        for (String pathEntry : classpath.split(System.getProperty("path.separator"))) {
            String[] paths = pathEntry.split(Pattern.quote(System.getProperty("file.separator")));
            String jarFile = paths[paths.length - 1];
            if ("fitnesse-standalone.jar".equals(jarFile)) {
                return pathEntry;
            }
            if (jarFile.matches("fitnesse-\\d\\d\\d\\d\\d\\d\\d\\d.jar")) {
                return pathEntry;
            }
            if (!jarFile.matches("fitnesse-standalone-\\d\\d\\d\\d\\d\\d\\d\\d.jar")) continue;
            return pathEntry;
        }
        return "fitnesse.jar";
    }

    public TestSystem(WikiPage page, TestSystemListener testSystemListener) {
        this.page = page;
        this.testSystemListener = testSystemListener;
    }

    protected String buildCommand(Descriptor descriptor) {
        String commandPattern = descriptor.getCommandPattern();
        String command = TestSystem.replace((String)commandPattern, (String)"%p", (String)descriptor.getClassPath());
        command = TestSystem.replace((String)command, (String)"%m", (String)descriptor.getTestRunner());
        return command;
    }

    protected static String replace(String value, String mark, String replacement) {
        return value.replaceAll(mark, Matcher.quoteReplacement(replacement));
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public void setManualStart(boolean manualStart) {
        this.manualStart = manualStart;
    }

    public static String getTestSystemType(String testSystemName) {
        String[] parts = testSystemName.split(":");
        return parts[0];
    }

    public void testOutputChunk(String output) throws IOException {
        this.testSystemListener.testOutputChunk(output);
    }

    public void testComplete(TestSummary testSummary) throws IOException {
        this.testSystemListener.testComplete(testSummary);
    }

    public void exceptionOccurred(Throwable e) {
        this.log.addException(e);
        this.testSystemListener.exceptionOccurred(e);
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.testSystemListener.testAssertionVerified(assertion, testResult);
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.testSystemListener.testExceptionOccurred(assertion, exceptionResult);
    }

    public abstract void start() throws IOException;

    public abstract void bye() throws IOException, InterruptedException;

    public abstract boolean isSuccessfullyStarted();

    public abstract void kill() throws IOException;

    public abstract void runTests(TestPage var1) throws IOException, InterruptedException;

    public final ExecutionLog getExecutionLog() {
        return this.log;
    }

    protected final void setExecutionLog(ExecutionLog log) {
        this.log = log;
    }

    public static Descriptor getDescriptor(WikiPage page, PageFactory pageFactory, boolean isRemoteDebug) {
        return new Descriptor(page, pageFactory, isRemoteDebug);
    }

    protected Map<String, String> createClasspathEnvironment(String classPath) {
        String classpathProperty = this.page.readOnlyData().getVariable("CLASSPATH_PROPERTY");
        Map<String, String> environmentVariables = null;
        if (classpathProperty != null) {
            environmentVariables = Collections.singletonMap(classpathProperty, classPath);
        }
        return environmentVariables;
    }
}

