/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SlimTestContextImpl
implements SlimTestContext {
    private Map<String, String> symbols = new HashMap();
    private Map<String, ScenarioTable> scenarios = new HashMap();
    private TestSummary testSummary = new TestSummary();

    public String getSymbol(String symbolName) {
        return (String)this.symbols.get(symbolName);
    }

    public void setSymbol(String symbolName, String value) {
        this.symbols.put(symbolName, value);
    }

    public void addScenario(String scenarioName, ScenarioTable scenarioTable) {
        this.scenarios.put(scenarioName, scenarioTable);
    }

    public ScenarioTable getScenario(String scenarioName) {
        return (ScenarioTable)this.scenarios.get(scenarioName);
    }

    public Collection<ScenarioTable> getScenarios() {
        return this.scenarios.values();
    }

    public void incrementPassedTestsCount() {
        ++this.testSummary.right;
    }

    public void incrementFailedTestsCount() {
        ++this.testSummary.wrong;
    }

    public void incrementErroredTestsCount() {
        ++this.testSummary.exceptions;
    }

    public void incrementIgnoredTestsCount() {
        ++this.testSummary.ignores;
    }

    public void increment(ExecutionResult result) {
        this.testSummary.add(result);
    }

    public void increment(TestSummary testSummary) {
        this.testSummary.add(testSummary);
    }

    public TestSummary getTestSummary() {
        return this.testSummary;
    }

    public void clearTestSummary() {
        this.testSummary = new TestSummary();
    }
}

