/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.results;

import fitnesse.testsystems.ExecutionResult;

public class TestResult {
    private final String actual;
    private final String expected;
    private final ExecutionResult executionResult;
    private final String message;
    private final boolean counts;

    public TestResult(ExecutionResult executionResult) {
        this(null, null, null, executionResult, true);
    }

    protected TestResult(String actual, String expected, String message, ExecutionResult executionResult) {
        this(actual, expected, message, executionResult, true);
    }

    protected TestResult(String actual, String expected, String message, ExecutionResult executionResult, boolean counts) {
        this.actual = actual;
        this.expected = expected;
        this.message = message;
        this.executionResult = executionResult;
        this.counts = counts;
    }

    public boolean doesCount() {
        return this.counts;
    }

    public boolean hasActual() {
        return this.actual != null;
    }

    public String getActual() {
        return this.actual;
    }

    public boolean hasExpected() {
        return this.expected != null;
    }

    public String getExpected() {
        return this.expected;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getMessage() {
        return this.message;
    }

    public ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public TestResult negateTestResult() {
        ExecutionResult newExecutionResult = this.executionResult == ExecutionResult.PASS ? ExecutionResult.FAIL : (this.executionResult == ExecutionResult.FAIL ? ExecutionResult.PASS : this.executionResult);
        return new TestResult(this.actual, this.expected, this.message, newExecutionResult);
    }

    public String toString(String originalContent) {
        StringBuilder builder = new StringBuilder();
        if (this.executionResult != null) {
            builder.append(this.executionResult.toString()).append('(');
        }
        if (this.hasActual()) {
            builder.append("a=").append(this.getActual());
            if (this.hasExpected() || this.hasMessage()) {
                builder.append(";");
            }
        }
        if (this.hasExpected()) {
            builder.append("e=").append(this.getExpected());
            if (this.hasMessage()) {
                builder.append(";");
            }
        }
        if (this.hasMessage()) {
            builder.append(this.getMessage());
        } else if (!this.hasActual() && !this.hasExpected()) {
            builder.append(originalContent);
        }
        if (this.executionResult != null) {
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public static TestResult pass() {
        return new TestResult(ExecutionResult.PASS);
    }

    public static TestResult pass(String message) {
        return new TestResult(null, null, message, ExecutionResult.PASS);
    }

    public static TestResult pass(String actual, String expected) {
        return new TestResult(actual, expected, null, ExecutionResult.PASS);
    }

    public static TestResult fail() {
        return new TestResult(null, null, null, ExecutionResult.FAIL);
    }

    public static TestResult fail(String message) {
        return new TestResult(null, null, message, ExecutionResult.FAIL);
    }

    public static TestResult fail(String actual, String expected) {
        return new TestResult(actual, expected, null, ExecutionResult.FAIL);
    }

    public static TestResult fail(String actual, String expected, String message) {
        return new TestResult(actual, expected, message, ExecutionResult.FAIL);
    }

    public static TestResult ignore() {
        return new TestResult(ExecutionResult.IGNORE);
    }

    public static TestResult ignore(String message) {
        return new TestResult(null, null, message, ExecutionResult.IGNORE);
    }

    public static TestResult error(String message) {
        return new TestResult(null, null, message, ExecutionResult.ERROR);
    }

    public static TestResult error(String message, String actual) {
        return new TestResult(actual, null, message, ExecutionResult.ERROR);
    }

    public static TestResult plain() {
        return new TestResult(null, null, null, null);
    }

    public static TestResult plain(String message) {
        return new TestResult(null, null, message, null);
    }

    public static TestResult ok(String message) {
        return new TestResult(null, null, message, ExecutionResult.PASS, false);
    }
}

