/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class DecisionTableTest {
    private WikiPage root;
    private final String simpleDecisionTable = "|DT:fixture|argument|\n|var|func?|\n|3|5|\n|7|9|\n";
    private final String decisionTableWithSameSetterMultipleTimes = "|DT:fixture|argument|\n|var|var|\n|3|5|\n|7|9|\n";
    private final String decisionTableWithSameFunctionMultipleTimes = "|DT:fixture|argument|\n|func?|func?|\n|3|5|\n|7|9|\n";
    private DecisionTable decisionTable;
    private SlimTestContextImpl testContext;
    private List<Assertion> assertions;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
        this.testContext = new SlimTestContextImpl();
    }

    private DecisionTable makeDecisionTableAndBuildInstructions(String tableText) throws Exception {
        this.decisionTable = this.makeDecisionTable(tableText);
        this.assertions.addAll(this.decisionTable.getAssertions());
        return this.decisionTable;
    }

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    private DecisionTable makeDecisionTable(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        return new DecisionTable(t, "id", (SlimTestContext)this.testContext);
    }

    @Test(expected=SyntaxError.class)
    public void aDecisionTableWithOnlyTwoRowsIsBad() throws Exception {
        this.makeDecisionTableWithTwoRows();
    }

    private void assertTableIsBad(DecisionTable decisionTable) {
        Assert.assertTrue((boolean)this.firstCellOfTable(decisionTable).contains("Bad table"));
    }

    private String firstCellOfTable(DecisionTable decisionTable) {
        return decisionTable.getTable().getCellContents(0, 0);
    }

    private DecisionTable makeDecisionTableWithTwoRows() throws Exception {
        return this.makeDecisionTableAndBuildInstructions("|x|\n|y|\n");
    }

    @Test(expected=SyntaxError.class)
    public void wrongNumberOfColumns() throws Exception {
        DecisionTable aDecisionTable = this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|var|var2|\n|3|\n|7|9|\n");
        this.assertTableIsBad(aDecisionTable);
    }

    @Test
    public void decisionTableCanBeConstructorOnly() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|fixture|argument|\n");
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction("decisionTable_id_0", "decisionTable_id", "fixture", new Object[]{"argument"}), new CallInstruction("decisionTable_id_1", "decisionTable_id", "table", new Object[]{ListUtility.list()})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"decisionTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"decisionTable_id_1", "OK"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String colorizedTable = this.decisionTable.getTable().toString();
        String expectedColorizedTable = "[[pass(fixture), argument]]";
        Assert.assertEquals((Object)expectedColorizedTable, (Object)colorizedTable);
    }

    @Test
    public void canBuildInstructionsForSimpleDecisionTable() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|var|func?|\n|3|5|\n|7|9|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture", new Object[]{"argument"}), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"var", "func?"}), ListUtility.list((String[])new String[]{"3", "5"}), ListUtility.list((String[])new String[]{"7", "9"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"3"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"7"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void canBuildInstructionsForMultipleCallsToSameSetter() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|var|var|\n|3|5|\n|7|9|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture", new Object[]{"argument"}), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"var", "var"}), ListUtility.list((String[])new String[]{"3", "5"}), ListUtility.list((String[])new String[]{"7", "9"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"3"}), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"5"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"7"}), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"9"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void canBuildInstructionsForMultipleCallsToSameFunction() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|func?|func?|\n|3|5|\n|7|9|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture", new Object[]{"argument"}), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"func?", "func?"}), ListUtility.list((String[])new String[]{"3", "5"}), ListUtility.list((String[])new String[]{"7", "9"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    private String id(int n) {
        return "decisionTable_id_" + n;
    }

    @Test
    public void canUseBangToCallFunction() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|var|func!|\n|3|5|\n|7|9|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture", new Object[]{"argument"}), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"var", "func!"}), ListUtility.list((String[])new String[]{"3", "5"}), ListUtility.list((String[])new String[]{"7", "9"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"3"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"7"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void settersAreFirstFunctionsAreLastLeftToRight() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|\n|a|fa?|b|fb?|c|fc?|d|e|f|fd?|fe?|ff?|\n|a|a|b|b|c|c|d|e|f|d|e|f|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture"), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"a", "fa?", "b", "fb?", "c", "fc?", "d", "e", "f", "fd?", "fe?", "ff?"}), ListUtility.list((String[])new String[]{"a", "a", "b", "b", "c", "c", "d", "e", "f", "d", "e", "f"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setA", new Object[]{"a"}), new CallInstruction(this.id(n++), "decisionTable_id", "setB", new Object[]{"b"}), new CallInstruction(this.id(n++), "decisionTable_id", "setC", new Object[]{"c"}), new CallInstruction(this.id(n++), "decisionTable_id", "setD", new Object[]{"d"}), new CallInstruction(this.id(n++), "decisionTable_id", "setE", new Object[]{"e"}), new CallInstruction(this.id(n++), "decisionTable_id", "setF", new Object[]{"f"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "fa"), new CallInstruction(this.id(n++), "decisionTable_id", "fb"), new CallInstruction(this.id(n++), "decisionTable_id", "fc"), new CallInstruction(this.id(n++), "decisionTable_id", "fd"), new CallInstruction(this.id(n++), "decisionTable_id", "fe"), new CallInstruction(this.id(n++), "decisionTable_id", "ff"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void canBuildInstructionsForTableWithVariables() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|\n|var|func?|\n|3|$V=|\n|$V|9|\n");
        int n = 0;
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction(this.id(n++), "decisionTable_id", "fixture"), new CallInstruction(this.id(n++), "decisionTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"var", "func?"}), ListUtility.list((String[])new String[]{"3", "$V="}), ListUtility.list((String[])new String[]{"$V", "9"})})}), new CallInstruction(this.id(n++), "decisionTable_id", "beginTable"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"3"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallAndAssignInstruction(this.id(n++), "V", "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "reset"), new CallInstruction(this.id(n++), "decisionTable_id", "setVar", new Object[]{"$V"}), new CallInstruction(this.id(n++), "decisionTable_id", "execute"), new CallInstruction(this.id(n++), "decisionTable_id", "func"), new CallInstruction(this.id(n++), "decisionTable_id", "endTable")});
        Assert.assertEquals((Object)expectedInstructions.toString(), (Object)this.instructions().toString());
    }

    @Test
    public void canEvaluateReturnValuesAndColorizeTable() throws Exception {
        DecisionTable dt = this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|var|func?|\n|3|5|\n|7|9|\n");
        int n = 0;
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{this.id(n++), "OK"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String colorizedTable = dt.getTable().toString();
        String expectedColorizedTable = "[[pass(DT:fixture), argument], [var, func?], [3, pass(5)], [7, fail(a=5;e=9)]]";
        Assert.assertEquals((Object)expectedColorizedTable, (Object)colorizedTable);
    }

    @Test
    public void translatesTestTablesIntoLiteralTables() throws Exception {
        DecisionTable dt = this.makeDecisionTableAndBuildInstructions("!|DT:fixture|argument|\n|var|func?|\n|3|5|\n|7|9|\n");
        int n = 0;
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{this.id(n++), "OK"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String colorizedTable = dt.getTable().toString();
        String expectedColorizedTable = "[[pass(DT:fixture), argument], [var, func?], [3, pass(5)], [7, fail(a=5;e=9)]]";
        Assert.assertEquals((Object)expectedColorizedTable, (Object)colorizedTable);
    }

    @Test
    public void canEvaluateReturnValuesAndColorizeTableForMultipleCallsToSameFunction() throws Exception {
        DecisionTable dt = this.makeDecisionTableAndBuildInstructions("|DT:fixture|argument|\n|func?|func?|\n|3|5|\n|7|9|\n");
        int n = 0;
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{this.id(n++), "OK"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "4"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"}), ListUtility.list((String[])new String[]{this.id(n++), "7"}), ListUtility.list((String[])new String[]{this.id(n++), "5"}), ListUtility.list((String[])new String[]{this.id(n++), "/__VOID__/"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String colorizedTable = dt.getTable().toString();
        String expectedColorizedTable = "[[pass(DT:fixture), argument], [func?, func?], [fail(a=4;e=3), pass(5)], [pass(7), fail(a=5;e=9)]]";
        Assert.assertEquals((Object)expectedColorizedTable, (Object)colorizedTable);
    }

    @Test
    public void usesDisgracedClassNames() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:slim test|\n|x|\n|y|\n");
        MakeInstruction makeInstruction = new MakeInstruction("decisionTable_id_0", "decisionTable_id", "SlimTest");
        Assert.assertEquals((Object)makeInstruction, this.instructions().get(0));
    }

    @Test
    public void usesDisgracedMethodNames() throws Exception {
        this.makeDecisionTableAndBuildInstructions("|DT:fixture|\n|my var|my func?|\n|8|7|\n");
        CallInstruction setInstruction = new CallInstruction("decisionTable_id_4", "decisionTable_id", "setMyVar", new Object[]{"8"});
        CallInstruction callInstruction = new CallInstruction("decisionTable_id_6", "decisionTable_id", "myFunc");
        Assert.assertEquals((Object)setInstruction, this.instructions().get(4));
        Assert.assertEquals((Object)callInstruction, this.instructions().get(6));
    }
}

