/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class ScenarioAndDecisionTableTest
extends SlimTestContextImpl {
    private WikiPage root;
    private List<Assertion> assertions;
    private ScenarioTable st;
    private DecisionTable dt;

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
        this.clearTestSummary();
    }

    private void makeTables(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.st = new ScenarioTable(t, "s_id", (SlimTestContext)this);
        t = ts.getTable(1);
        this.dt = new DecisionTable(t, "did", (SlimTestContext)this);
        this.assertions.addAll(this.st.getAssertions());
        this.assertions.addAll(this.dt.getAssertions());
    }

    @Test
    public void bracesArountArgumentInTable() throws Exception {
        this.makeTables("!|scenario|echo|user|giving|user_old|\n|check|echo|@{user}|@{user_old}|\n\n!|DT:EchoGiving|\n|user|user_old|\n|7|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"decisionTable_did_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.dt.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, user, giving, user_old], [check, echo, 7, pass(7)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.dt.getTable().toString();
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test
    public void oneInput() throws Exception {
        this.makeTables("!|scenario|myScenario|input|\n|function|@input|\n\n!|DT:myScenario|\n|input|\n|7|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("decisionTable_did_0/scriptTable_s_id_0", "scriptTableActor", "function", new Object[]{"7"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void manyInputsAndRows() throws Exception {
        this.makeTables("!|scenario|login|user name|password|password|pin|pin|\n|login|@userName|with password|@password|and pin|@pin|\n\n!|DT:LoginPasswordPin|\n|user name|password|pin|\n|bob|xyzzy|7734|\n|bill|yabba|8892|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("decisionTable_did_0/scriptTable_s_id_0", "scriptTableActor", "loginWithPasswordAndPin", new Object[]{"bob", "xyzzy", "7734"}), new CallInstruction("decisionTable_did_1/scriptTable_s_id_0", "scriptTableActor", "loginWithPasswordAndPin", new Object[]{"bill", "yabba", "8892"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void simpleInputAndOutputPassing() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output|\n|check|echo|@input|@output|\n\n!|DT:EchoGiving|\n|input|output|\n|7|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"decisionTable_did_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.dt.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output], [check, echo, 7, pass(7)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.dt.getTable().toString();
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test
    public void simpleInputAndOutputFailing() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output|\n|check|echo|@input|@output|\n\n!|DT:EchoGiving|\n|input|output|\n|7|8|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"decisionTable_did_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.dt.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output], [check, echo, 7, fail(a=7;e=8)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.dt.getTable().toString();
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test(expected=SyntaxError.class)
    public void scenarioHasTooFewArguments() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|\n|check|echo|@input|@output|\n\n!|DT:EchoGiving|\n|input|output|\n|7|8|\n");
    }

    @Test
    public void scenarioHasExtraArgumentsThatAreIgnored() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output||output2|\n|check|echo|@input|@output|\n\n!|DT:EchoGiving|\n|input|output|\n|7|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"decisionTable_did_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.dt.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output, , output2], [check, echo, 7, pass(7)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.dt.getTable().toString();
    }
}

