/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScenarioTable
extends SlimTable {
    private static final String instancePrefix = "scenarioTable";
    private static final String underscorePattern = "\\W_(?:\\W|$)";
    private String name;
    private List<String> inputs = new ArrayList();
    private Set<String> outputs = new HashSet();
    private final int colsInHeader = this.table.getColumnCountInRow(0);
    private boolean parameterized = false;

    public ScenarioTable(Table table, String tableId, SlimTestContext testContext) {
        super(table, tableId, testContext);
    }

    protected String getTableType() {
        return "scenarioTable";
    }

    public List<Assertion> getAssertions() throws SyntaxError {
        this.parseTable();
        return Collections.emptyList();
    }

    private void parseTable() throws SyntaxError {
        this.validateHeader();
        String firstNameCell = this.table.getCellContents(1, 0);
        this.parameterized = ScenarioTable.isNameParameterized((String)firstNameCell);
        this.name = this.getScenarioName();
        this.getTestContext().addScenario(this.name, this);
        this.getScenarioArguments();
    }

    private void getScenarioArguments() {
        if (this.parameterized) {
            this.getArgumentsForParameterizedName();
        } else {
            this.getArgumentsForAlternatingName();
        }
    }

    private void getArgumentsForAlternatingName() {
        for (int inputCol = 2; inputCol < this.colsInHeader; inputCol += 2) {
            String disgracedArgName;
            String argName = this.table.getCellContents(inputCol, 0);
            if (argName.endsWith("?")) {
                disgracedArgName = SlimTable.Disgracer.disgraceMethodName((String)argName.substring(0, argName.length()));
                this.outputs.add(disgracedArgName);
                continue;
            }
            disgracedArgName = SlimTable.Disgracer.disgraceMethodName((String)argName);
            this.inputs.add(disgracedArgName);
        }
    }

    private void getArgumentsForParameterizedName() {
        String[] arguments;
        String argumentString = this.table.getCellContents(2, 0);
        for (String argument : arguments = argumentString.split(",")) {
            this.inputs.add(SlimTable.Disgracer.disgraceMethodName((String)argument.trim()));
        }
    }

    public String getScenarioName() {
        if (this.parameterized) {
            String parameterizedName = this.table.getCellContents(1, 0);
            return ScenarioTable.unparameterize((String)parameterizedName);
        }
        return this.getNameFromAlternatingCells();
    }

    public static boolean isNameParameterized(String firstNameCell) {
        Pattern regPat = Pattern.compile("\\W_(?:\\W|$)");
        Matcher underscoreMatcher = regPat.matcher(firstNameCell);
        return underscoreMatcher.find();
    }

    public static String unparameterize(String firstNameCell) {
        String name = firstNameCell.replaceAll("\\W_(?:\\W|$)", " ").trim();
        return SlimTable.Disgracer.disgraceClassName((String)name);
    }

    private String getNameFromAlternatingCells() {
        StringBuffer nameBuffer = new StringBuffer();
        for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
            nameBuffer.append(this.table.getCellContents(nameCol, 0)).append(" ");
        }
        return SlimTable.Disgracer.disgraceClassName((String)nameBuffer.toString().trim());
    }

    private void validateHeader() throws SyntaxError {
        if (this.colsInHeader <= 1) {
            throw new SyntaxError("Scenario tables must have a name.");
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getInputs() {
        return new HashSet<String>(this.inputs);
    }

    public Set<String> getOutputs() {
        return this.outputs;
    }

    public List<Assertion> call(Map<String, String> scenarioArguments, SlimTable parentTable, int row) throws SyntaxError {
        Table newTable = this.getTable().asTemplate((Table.CellContentSubstitution)new /* Unavailable Anonymous Inner Class!! */);
        ScriptTable t = new ScriptTable(newTable, this.id, (SlimTestContext)new ScenarioTestContext(this, parentTable.getTestContext()));
        parentTable.addChildTable((SlimTable)t, row);
        List assertions = t.getAssertions();
        assertions.add(this.makeAssertion(Instruction.NOOP_INSTRUCTION, (Expectation)new ScenarioExpectation(this, t, row, null)));
        return assertions;
    }

    public List<Assertion> call(String[] args, ScriptTable parentTable, int row) throws SyntaxError {
        HashMap scenarioArguments = new HashMap();
        for (int i = 0; i < this.inputs.size() && i < args.length; ++i) {
            scenarioArguments.put(this.inputs.get(i), args[i]);
        }
        return this.call(scenarioArguments, (SlimTable)parentTable, row);
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    public String[] matchParameters(String invokingString) {
        String parameterizedName;
        if (this.parameterized) {
            parameterizedName = this.table.getCellContents(1, 0);
        } else if (this.inputs.size() > 0) {
            StringBuilder nameBuffer = new StringBuilder();
            for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
                nameBuffer.append(this.table.getCellContents(nameCol, 0)).append(" _ ");
            }
            parameterizedName = nameBuffer.toString().trim();
        } else {
            return null;
        }
        return this.getArgumentsMatchingParameterizedName(parameterizedName, invokingString);
    }

    private String[] getArgumentsMatchingParameterizedName(String parameterizedName, String invokingString) {
        Matcher matcher = this.makeParameterizedNameMatcher(parameterizedName, invokingString);
        if (matcher.matches()) {
            return this.extractNamesFromMatcher(matcher);
        }
        return null;
    }

    private Matcher makeParameterizedNameMatcher(String parameterizedName, String invokingString) {
        String patternString = parameterizedName.replaceAll("_", "(.*)");
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(invokingString);
        return matcher;
    }

    private String[] extractNamesFromMatcher(Matcher matcher) {
        String[] arguments = new String[matcher.groupCount()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = matcher.group(i + 1);
        }
        return arguments;
    }
}

