/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTableTest {
    private WikiPage root;
    private List<Object> instructions;
    public ScenarioTable st;
    private SlimTestContextImpl testContext;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.instructions = new ArrayList();
    }

    private ScenarioTable makeScenarioTable(String pageContents) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)pageContents);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.testContext = new SlimTestContextImpl();
        this.st = new ScenarioTable(t, "id", (SlimTestContext)this.testContext);
        this.instructions.addAll(this.st.getAssertions());
        return this.st;
    }

    @Test
    public void noArgs() throws Exception {
        this.makeScenarioTable("|scenario|myScenario|\n");
        Assert.assertEquals((Object)"myScenario", (Object)this.st.getName());
        Assert.assertEquals((long)0L, (long)this.st.getInputs().size());
        Assert.assertEquals((long)0L, (long)this.st.getOutputs().size());
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void oneInputArg() throws Exception {
        this.makeScenarioTable("|scenario|myScenario|input|\n");
        Assert.assertEquals((Object)"myScenario", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("input"));
        Assert.assertEquals((long)0L, (long)this.st.getOutputs().size());
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void oneInputArgWithTrailingName() throws Exception {
        this.makeScenarioTable("|scenario|myScenario|input|trailer|\n");
        Assert.assertEquals((Object)"MyScenarioTrailer", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("input"));
        Assert.assertEquals((long)0L, (long)this.st.getOutputs().size());
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void manyInputsNoTrailer() throws Exception {
        this.makeScenarioTable("|scenario|login user|user name|with password|password|\n");
        Assert.assertEquals((Object)"LoginUserWithPassword", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)2L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("userName"));
        Assert.assertTrue((boolean)inputs.contains("password"));
        Assert.assertEquals((long)0L, (long)this.st.getOutputs().size());
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void manyInputsWithTrailer() throws Exception {
        this.makeScenarioTable("|scenario|login user|user name|with password|password|now|\n");
        Assert.assertEquals((Object)"LoginUserWithPasswordNow", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)2L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("userName"));
        Assert.assertTrue((boolean)inputs.contains("password"));
        Assert.assertEquals((long)0L, (long)this.st.getOutputs().size());
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void manyInputsAndOutputs() throws Exception {
        this.makeScenarioTable("|scenario|login user|user name|with password|password|giving message|message?|and status|login status?|\n");
        Assert.assertEquals((Object)"LoginUserWithPasswordGivingMessageAndStatus", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)2L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("userName"));
        Assert.assertTrue((boolean)inputs.contains("password"));
        Set outputs = this.st.getOutputs();
        Assert.assertEquals((long)2L, (long)outputs.size());
        Assert.assertTrue((boolean)outputs.contains("message"));
        Assert.assertTrue((boolean)outputs.contains("loginStatus"));
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void simpleNameWithUnnamedArguments() throws Exception {
        this.makeScenarioTable("|scenario|f|a||b|\n");
        Assert.assertEquals((Object)"f", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)2L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("a"));
        Assert.assertTrue((boolean)inputs.contains("b"));
        Assert.assertFalse((boolean)this.st.isParameterized());
    }

    @Test
    public void parameterizedNameWithOneArgAtEnd() throws Exception {
        this.makeScenarioTable("|scenario|login user _|name|\n");
        Assert.assertEquals((Object)"LoginUser", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("name"));
        Assert.assertTrue((boolean)this.st.isParameterized());
    }

    @Test
    public void parameterizedNameWithOneArgInMiddle() throws Exception {
        this.makeScenarioTable("|scenario|login _ user|name|\n");
        Assert.assertEquals((Object)"LoginUser", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("name"));
        Assert.assertTrue((boolean)this.st.isParameterized());
    }

    @Test
    public void parameterizedNameWithTwoArgs() throws Exception {
        this.makeScenarioTable("|scenario|login user _ password _|name,password|\n");
        Assert.assertEquals((Object)"LoginUserPassword", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)2L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("name"));
        Assert.assertTrue((boolean)inputs.contains("password"));
        Assert.assertTrue((boolean)this.st.isParameterized());
    }

    @Test
    public void getArgumentsFromParameterizedInvocation() throws Exception {
        this.makeScenarioTable("|scenario|login user _ password _|name,password|\n");
        String[] arguments = this.st.matchParameters("login user Bob password xyzzy");
        Assert.assertEquals((long)2L, (long)arguments.length);
        Assert.assertEquals((Object)"Bob", (Object)arguments[0]);
        Assert.assertEquals((Object)"xyzzy", (Object)arguments[1]);
    }

    @Test
    public void parameterizedNameWithOneArgAtEndAndWordWithEmbeddedUnderscore() throws Exception {
        this.makeScenarioTable("|scenario|login user_name _|name|\n");
        Assert.assertEquals((Object)"LoginUser_name", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("name"));
        Assert.assertTrue((boolean)this.st.isParameterized());
    }

    @Test
    public void underscoreInWordNotParameterized() throws Exception {
        this.makeScenarioTable("|scenario|login user_name |name|\n");
        Assert.assertEquals((Object)"LoginUser_name", (Object)this.st.getName());
        Set inputs = this.st.getInputs();
        Assert.assertEquals((long)1L, (long)inputs.size());
        Assert.assertTrue((boolean)inputs.contains("name"));
        Assert.assertFalse((boolean)this.st.isParameterized());
    }
}

