/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.UpdateFileList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.FileUtil;
import util.RegexTestCase;

public class UpdateFileListTest {
    private UpdateFileList updater;

    @Before
    public void setUp() throws IOException {
        this.updater = new UpdateFileList();
        this.createMultiLevelDirectory();
    }

    @Test
    public void makeAnUpdateFileList() throws Exception {
        Assert.assertTrue((this.updater.getClass() == UpdateFileList.class ? 1 : 0) != 0);
    }

    @Test
    public void canParseTheCommandLine() throws Exception {
        this.updater.parseCommandLine(new String[]{"testDir"});
        Assert.assertEquals((long)1L, (long)this.updater.getDirectories().size());
        Assert.assertEquals((Object)"testDir", this.updater.getDirectories().get(0));
    }

    @Test
    public void shouldHandleInvalidCommandLine() throws Exception {
        boolean validCommandLine = this.updater.parseCommandLine(new String[0]);
        Assert.assertFalse((boolean)validCommandLine);
    }

    @Test
    public void shouldKnowIfAGivenDirectoryExists() throws Exception {
        File testFolder = new File("TestFolder");
        testFolder.mkdir();
        this.updater.parseCommandLine(new String[]{"TestFolder"});
        Assert.assertTrue((boolean)this.updater.directoriesAreValid());
        FileUtil.deleteFileSystemDirectory((File)testFolder);
        Assert.assertFalse((boolean)this.updater.directoriesAreValid());
    }

    @Test
    public void shouldCreateAFileWithTheListOfFileNames() throws Exception {
        String content = this.runCreateFileAndGetContent(new String[]{"MasterFolder"});
        RegexTestCase.assertSubString((String)"MasterFolder/MasterFile\n", (String)content);
    }

    @Test
    public void shouldMakeUpdateListWithMultiLevelFolders() throws Exception {
        String content = this.runCreateFileAndGetContent(new String[]{"MasterFolder"});
        RegexTestCase.assertSubString((String)"MasterFolder/MasterFile\n", (String)content);
        RegexTestCase.assertSubString((String)"MasterFolder/TestFolder/TestFile\n", (String)content);
    }

    @Test
    public void shouldKnowWhichSpecialFilesNotToInclude() throws Exception {
        String arg1 = "-doNotReplace:MasterFolder/TestFolder/fitnesse.css";
        String arg2 = "-doNotReplace:MasterFolder/TestFolder/fitnesse_print.css";
        String content = this.runCreateFileAndGetContent(new String[]{arg1, arg2, "MasterFolder/TestFolder"});
        RegexTestCase.assertSubString((String)"TestFolder/TestFile", (String)content);
        RegexTestCase.assertDoesntHaveRegexp((String)"TestFolder/fitnesse.css", (String)content);
        RegexTestCase.assertDoesntHaveRegexp((String)"TestFolder/fitnesse_print.css", (String)content);
    }

    @Test
    public void shouldPutSpecialFilesInDifferentList() throws Exception {
        String arg1 = "-doNotReplace:MasterFolder/TestFolder/fitnesse.css";
        String arg2 = "-doNotReplace:MasterFolder/TestFolder/fitnesse_print.css";
        this.updater.parseCommandLine(new String[]{arg1, arg2, "MasterFolder/TestFolder"});
        File doNotUpdateFile = this.updater.createDoNotUpdateList();
        String doNotUpdateContent = FileUtil.getFileContent((File)doNotUpdateFile);
        FileUtil.deleteFile((File)doNotUpdateFile);
        RegexTestCase.assertSubString((String)"TestFolder/fitnesse.css", (String)doNotUpdateContent);
        RegexTestCase.assertSubString((String)"TestFolder/fitnesse_print.css", (String)doNotUpdateContent);
        RegexTestCase.assertDoesntHaveRegexp((String)"TestFolder/TestFile", (String)doNotUpdateContent);
    }

    @Test
    public void shouldPrunePrefixes() throws Exception {
        String content = this.runCreateFileAndGetContent(new String[]{"-baseDirectory:MasterFolder/TestFolder", ""});
        RegexTestCase.assertSubString((String)"TestFile\n", (String)content);
        RegexTestCase.assertDoesntHaveRegexp((String)"TestFolder/TestFile", (String)content);
    }

    @Test
    public void testMainHappyPath() throws Exception {
        UpdateFileList updaterMock;
        String[] args = new String[]{"foo", "bar"};
        UpdateFileList.testUpdater = updaterMock = (UpdateFileList)Mockito.mock(UpdateFileList.class);
        Mockito.when((Object)updaterMock.directoriesAreValid()).thenReturn((Object)true);
        UpdateFileList.main((String[])args);
        ((UpdateFileList)Mockito.verify((Object)updaterMock)).parseCommandLine(args);
        ((UpdateFileList)Mockito.verify((Object)updaterMock)).createUpdateList();
        ((UpdateFileList)Mockito.verify((Object)updaterMock)).createDoNotUpdateList();
    }

    @Test
    public void testMainUnhappyPath() throws Exception {
        UpdateFileList updaterMock;
        String[] args = new String[]{"foo", "bar"};
        UpdateFileList.testUpdater = updaterMock = (UpdateFileList)Mockito.mock(UpdateFileList.class);
        Mockito.when((Object)updaterMock.directoriesAreValid()).thenReturn((Object)false);
        UpdateFileList.main((String[])args);
        ((UpdateFileList)Mockito.verify((Object)updaterMock)).printMessage("Some directories are invalid.");
        ((UpdateFileList)Mockito.verify((Object)updaterMock)).exit();
    }

    @Test
    public void shouldSplitUpWindowsLikePathNames() throws Exception {
        String[] args = new String[]{"-baseDirectory:C:\\FitNesse/Resources", "MasterFolder"};
        this.updater.parseCommandLine(args);
        Assert.assertEquals(Arrays.asList("C:\\FitNesse/Resources/MasterFolder"), (Object)this.updater.getDirectories());
    }

    private String runCreateFileAndGetContent(String[] args) throws Exception {
        this.updater.parseCommandLine(args);
        File resultFile = this.updater.createUpdateList();
        String content = FileUtil.getFileContent((File)resultFile);
        FileUtil.deleteFile((File)resultFile);
        return content;
    }

    private void createMultiLevelDirectory() throws IOException {
        FileUtil.createFile((String)"MasterFolder/MasterFile", (String)"");
        FileUtil.createFile((String)"MasterFolder/TestFolder/TestFile", (String)"");
        FileUtil.createFile((String)"MasterFolder/TestFolder/fitnesse.css", (String)"");
        FileUtil.createFile((String)"MasterFolder/TestFolder/fitnesse_print.css", (String)"");
    }

    @After
    public void tearDown() {
        FileUtil.deleteFileSystemDirectory((String)"MasterFolder");
    }
}

