/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.updates.FileUpdate;
import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.UpdaterImplementation;
import fitnesse.updates.UpdaterImplementationTest;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;

public class UpdaterImplementationTest {
    private File updateList;
    private File updateDoNotCopyOver;
    public static final String testDir = "testDir";
    public static final String rootName = "RooT";
    protected WikiPage root;
    protected Update update;
    protected UpdaterImplementation updater;
    protected WikiPage pageOne;
    protected WikiPage pageTwo;
    protected FitNesseContext context;
    protected PageCrawler crawler;
    private boolean updateDone = false;

    @Before
    public void setUp() throws Exception {
        this.setTheContext();
        this.root = this.setTheRoot();
        this.createFakeJarFileResources();
        this.createFakeUpdateListFiles();
        this.updater = new UpdaterImplementation(this.context);
    }

    private WikiPage setTheRoot() throws Exception {
        return this.root;
    }

    private void setTheContext() {
        FileUtil.makeDir((String)testDir);
        this.root = new FileSystemPage(testDir, rootName);
        this.crawler = this.root.getPageCrawler();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root, (String)testDir, (String)rootName, (int)80);
    }

    private void createFakeUpdateListFiles() {
        this.updateList = new File("classes/Resources/updateList");
        this.updateDoNotCopyOver = new File("classes/Resources/updateDoNotCopyOverList");
        FileUtil.createFile((File)this.updateList, (String)"files/TestFile\nfiles/BestFile\n");
        FileUtil.createFile((File)this.updateDoNotCopyOver, (String)"SpecialFile");
    }

    private void createFakeJarFileResources() throws IOException {
        FileUtil.createFile((String)"classes/Resources/files/TestFile", (String)"");
        FileUtil.createFile((String)"classes/Resources/files/BestFile", (String)"");
        FileUtil.createFile((String)"classes/Resources/SpecialFile", (String)"");
    }

    @Test
    public void shouldBeAbleToGetUpdateFilesAndMakeAlistFromThem() throws Exception {
        ArrayList updateArrayList = new ArrayList();
        this.updater.tryToParseTheFileIntoTheList(this.updateList, updateArrayList);
        Assert.assertEquals((Object)"files/TestFile", updateArrayList.get(0));
        Assert.assertEquals((Object)"files/BestFile", updateArrayList.get(1));
        updateArrayList = new ArrayList();
        this.updater.tryToParseTheFileIntoTheList(this.updateDoNotCopyOver, updateArrayList);
        Assert.assertEquals((Object)"SpecialFile", updateArrayList.get(0));
    }

    @Test
    public void shouldBeAbleToGetThePathOfJustTheParent() throws Exception {
        String filePath = this.updater.getCorrectPathForTheDestination("classes/files/moreFiles/TestFile");
        RegexTestCase.assertSubString((String)this.portablePath("classes/files/moreFiles"), (String)filePath);
    }

    private String portablePath(String path) {
        return FileUtil.buildPath((String[])path.split("/"));
    }

    @Test
    public void shouldCreateTheCorrectPathForGivenPath() throws Exception {
        String filePath = this.updater.getCorrectPathFromJar("FitNesseRoot/files/moreFiles/TestFile");
        Assert.assertEquals((Object)"Resources/FitNesseRoot/files/moreFiles/TestFile", (Object)filePath);
    }

    @Test
    public void shouldCreateSomeFilesInTheRooTDirectory() throws Exception {
        for (Update update : this.updater.updates) {
            if (update.getClass() != ReplacingFileUpdate.class && update.getClass() != FileUpdate.class) continue;
            update.doUpdate();
        }
        File testFile = new File(this.context.rootPath, "files/TestFile");
        File bestFile = new File(this.context.rootPath, "files/BestFile");
        File specialFile = new File(this.context.rootPath, "SpecialFile");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((boolean)bestFile.exists());
        Assert.assertTrue((boolean)specialFile.exists());
        Assert.assertFalse((boolean)testFile.isDirectory());
        Assert.assertFalse((boolean)bestFile.isDirectory());
        Assert.assertFalse((boolean)specialFile.isDirectory());
    }

    @Test
    public void updatesShouldBeRunIfCurrentVersionNotAlreadyUpdated() throws Exception {
        String version = "TestVersion";
        this.updater.setFitNesseVersion(version);
        UpdaterImplementation.testing = true;
        File propertiesFile = new File("testDir/RooT/properties");
        FileUtil.deleteFile((File)propertiesFile);
        Assert.assertFalse((boolean)propertiesFile.exists());
        this.updater.updates = new Update[]{new UpdateSpy(this, null)};
        this.updater.update();
        Assert.assertTrue((boolean)this.updateDone);
        Assert.assertTrue((boolean)propertiesFile.exists());
        Properties properties = this.updater.loadProperties();
        Assert.assertTrue((boolean)properties.containsKey("Version"));
        Assert.assertEquals((Object)version, (Object)properties.get("Version"));
        FileUtil.deleteFile((File)propertiesFile);
    }

    @Test
    public void updatesShouldNotBeRunIfCurrentVersionAlreadyUpdated() throws Exception {
        String version = "TestVersion";
        this.updater.setFitNesseVersion(version);
        Properties properties = this.updater.getProperties();
        properties.put("Version", version);
        this.updater.updates = new Update[]{new UpdateSpy(this, null)};
        this.updater.update();
        Assert.assertFalse((boolean)this.updateDone);
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionInNoUpdateFileExists() throws Exception {
        FileUtil.deleteFile((File)this.updateList);
        this.updater.tryToParseTheFileIntoTheList(this.updateList, new ArrayList());
    }

    @After
    public void tearDown() {
        FileUtil.deleteFileSystemDirectory((String)"classes/Resources");
        FileUtil.deleteFileSystemDirectory((String)testDir);
    }

    static /* synthetic */ boolean access$102(UpdaterImplementationTest x0, boolean x1) {
        x0.updateDone = x1;
        return x0.updateDone;
    }
}

