/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.File;
import java.util.List;
import util.EnvironmentVariableTool;
import util.FileUtil;

public abstract class BaseWikiPage
implements WikiPage {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected WikiPage parent;

    protected BaseWikiPage(String name, WikiPage parent) {
        this.name = name;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl();
    }

    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    protected abstract List<WikiPage> getNormalChildren();

    public List<WikiPage> getChildren() {
        List children = this.getNormalChildren();
        WikiPageProperties props = this.getData().getProperties();
        WikiPageProperty symLinksProperty = props.getProperty("SymbolicLinks");
        if (symLinksProperty != null) {
            for (String linkName : symLinksProperty.keySet()) {
                WikiPage page = this.createSymbolicPage(symLinksProperty, linkName);
                if (page == null || children.contains(page)) continue;
                children.add(page);
            }
        }
        return children;
    }

    private WikiPage createSymbolicPage(WikiPageProperty symLinkProperty, String linkName) {
        if (symLinkProperty == null) {
            return null;
        }
        String linkPath = symLinkProperty.get(linkName);
        if (linkPath == null) {
            return null;
        }
        if (linkPath.startsWith("file://")) {
            return this.createExternalSymbolicLink(linkPath, linkName);
        }
        return this.createInternalSymbolicPage(linkPath, linkName);
    }

    private WikiPage createExternalSymbolicLink(String linkPath, String linkName) {
        String fullPagePath = EnvironmentVariableTool.replace((String)linkPath.substring(7));
        File file = new File(fullPagePath);
        File parentDirectory = file.getParentFile();
        if (parentDirectory.exists()) {
            if (!file.exists()) {
                FileUtil.makeDir((String)file.getPath());
            }
            if (file.isDirectory()) {
                FileSystemPage externalRoot = new FileSystemPage(parentDirectory.getPath(), file.getName());
                return new SymbolicPage(linkName, (WikiPage)externalRoot, (WikiPage)this);
            }
        }
        return null;
    }

    protected WikiPage createInternalSymbolicPage(String linkPath, String linkName) {
        WikiPagePath path = PathParser.parse((String)linkPath);
        BaseWikiPage start = path.isRelativePath() ? this.getParent() : this;
        WikiPage page = this.getPageCrawler().getPage((WikiPage)start, path);
        if (page != null) {
            page = new SymbolicPage(linkName, page, (WikiPage)this);
        }
        return page;
    }

    protected abstract WikiPage getNormalChildPage(String var1);

    public WikiPage getChildPage(String name) {
        WikiPage page = this.getNormalChildPage(name);
        if (page == null) {
            page = this.createSymbolicPage(this.readOnlyData().getProperties().getProperty("SymbolicLinks"), name);
        }
        return page;
    }

    public WikiPage getHeaderPage() {
        return PageCrawlerImpl.getClosestInheritedPage((String)"PageHeader", (WikiPage)this);
    }

    public WikiPage getFooterPage() {
        return PageCrawlerImpl.getClosestInheritedPage((String)"PageFooter", (WikiPage)this);
    }

    public boolean isOpenInNewWindow() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    public int compareTo(Object o) {
        try {
            return this.getName().compareTo(((WikiPage)o).getName());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WikiPage)) {
            return false;
        }
        try {
            PageCrawler crawler = this.getPageCrawler();
            return crawler.getFullPath((WikiPage)this).equals((Object)crawler.getFullPath((WikiPage)o));
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath((WikiPage)this).hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getHelpText() {
        String helpText = this.getData().getAttribute("Help");
        return helpText == null || helpText.length() == 0 ? null : helpText;
    }
}

