/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.TimeMeasurement;

public abstract class CachingPage
extends CommitingPage {
    private static final long serialVersionUID = 1L;
    public static int cacheTime = 3000;
    protected Map<String, WikiPage> children = new HashMap();
    private transient SoftReference<PageData> cachedData;
    private transient TimeMeasurement cachedTime;

    public CachingPage(String name, WikiPage parent) {
        super(name, parent);
    }

    protected abstract WikiPage createChildPage(String var1);

    protected abstract void loadChildren();

    protected abstract PageData makePageData();

    public WikiPage addChildPage(String name) {
        WikiPage page = this.createChildPage(name);
        this.children.put(name, page);
        return page;
    }

    public List<WikiPage> getNormalChildren() {
        this.loadChildren();
        return this.getCachedChildren();
    }

    public List<WikiPage> getCachedChildren() {
        return new ArrayList<WikiPage>(this.children.values());
    }

    public void removeChildPage(String name) {
        if (this.hasCachedSubpage(name)) {
            this.children.remove(name);
        }
    }

    public WikiPage getNormalChildPage(String name) {
        if (this.hasCachedSubpage(name) || this.hasChildPage(name)) {
            return (WikiPage)this.children.get(name);
        }
        return null;
    }

    protected boolean hasCachedSubpage(String name) {
        return this.children.containsKey(name);
    }

    public PageData getData() {
        if (this.cachedDataExpired()) {
            this.ReloadCache();
        }
        return new PageData(this.getCachedData());
    }

    private void ReloadCache() {
        PageData data = this.makePageData();
        this.setCachedData(data);
    }

    public ReadOnlyPageData readOnlyData() {
        if (this.getCachedData() == null) {
            this.ReloadCache();
        }
        return this.getCachedData();
    }

    private boolean cachedDataExpired() {
        return this.getCachedData() == null || this.cachedTime.elapsed() >= (long)cacheTime;
    }

    public void dumpExpiredCachedData() {
        if (this.cachedDataExpired()) {
            this.clearCache();
        }
    }

    public VersionInfo commit(PageData data) {
        VersionInfo versionInfo = super.commit(data);
        this.setCachedData(this.makePageData());
        return versionInfo;
    }

    private void setCachedData(PageData data) {
        if (this.cachedData != null) {
            this.cachedData.clear();
        }
        this.cachedData = new SoftReference<PageData>(data);
        this.cachedTime = new TimeMeasurement().start();
    }

    public PageData getCachedData() {
        if (this.cachedData != null) {
            return (PageData)this.cachedData.get();
        }
        return null;
    }

    public void clearCache() {
        this.cachedData.clear();
        this.cachedData = null;
    }
}

