/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.ComponentFactory;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageRepository;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VersionsController;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.zip.ZipFileVersionsController;
import fitnesse.wikitext.parser.WikiWordPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import util.Clock;
import util.DiskFileSystem;
import util.FileSystem;
import util.FileUtil;

public class FileSystemPage
extends CachingPage {
    private static final long serialVersionUID = 1L;
    public static final String contentFilename = "/content.txt";
    public static final String propertiesFilename = "/properties.xml";
    private final String path;
    private final VersionsController versionsController;
    private CmSystem cmSystem = new CmSystem(this);

    public FileSystemPage(String path, String name, FileSystem fileSystem, ComponentFactory componentFactory) {
        super(name, null);
        this.path = path;
        this.versionsController = this.createVersionsController(componentFactory);
        this.createDirectoryIfNewPage(fileSystem);
    }

    public FileSystemPage(String path, String name) {
        this(path, name, (FileSystem)new DiskFileSystem(), new ComponentFactory());
    }

    public FileSystemPage(String name, FileSystemPage parent, FileSystem fileSystem) {
        super(name, (WikiPage)parent);
        this.path = parent.getFileSystemPath();
        this.versionsController = parent.versionsController;
        this.createDirectoryIfNewPage(fileSystem);
    }

    private VersionsController createVersionsController(ComponentFactory factory) {
        return (VersionsController)factory.createComponent("VersionsController", ZipFileVersionsController.class);
    }

    public void removeChildPage(String name) {
        super.removeChildPage(name);
        String pathToDelete = this.getFileSystemPath() + "/" + name;
        File fileToBeDeleted = new File(pathToDelete);
        this.cmSystem.preDelete(pathToDelete);
        FileUtil.deleteFileSystemDirectory((File)fileToBeDeleted);
        this.cmSystem.delete(pathToDelete);
    }

    public boolean hasChildPage(String pageName) {
        File f = new File(this.getFileSystemPath() + "/" + pageName);
        if (f.exists()) {
            this.addChildPage(pageName);
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void saveContent(String content) {
        if (content == null) {
            return;
        }
        String separator = System.getProperty("line.separator");
        if (content.endsWith("|")) {
            content = content + separator;
        }
        content = content.replaceAll("\r\n", "\n");
        content = content.replaceAll("\n", separator);
        String contentPath = this.getFileSystemPath() + contentFilename;
        File output = new File(contentPath);
        OutputStreamWriter writer = null;
        try {
            if (output.exists()) {
                this.cmSystem.edit(contentPath);
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8");
            writer.write(content);
            if (writer == null) return;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new RuntimeException("Can not decode file " + output, e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                FileUtil.close(writer);
                this.cmSystem.update(contentPath);
                throw throwable;
            }
        }
        FileUtil.close((Writer)writer);
        this.cmSystem.update(contentPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void saveAttributes(WikiPageProperties attributes) {
        FileOutputStream output = null;
        String propertiesFilePath = "<unknown>";
        try {
            propertiesFilePath = this.getFileSystemPath() + propertiesFilename;
            File propertiesFile = new File(propertiesFilePath);
            if (propertiesFile.exists()) {
                this.cmSystem.edit(propertiesFilePath);
            }
            output = new FileOutputStream(propertiesFile);
            WikiPageProperties propertiesToSave = new WikiPageProperties(attributes);
            this.removeAlwaysChangingProperties(propertiesToSave);
            propertiesToSave.save((OutputStream)output);
            if (output == null) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to save properties file: \"" + propertiesFilePath + "\" (exception: " + e + ").", e);
            }
            catch (Throwable throwable) {
                if (output == null) throw throwable;
                FileUtil.close(output);
                this.cmSystem.update(propertiesFilePath);
                throw throwable;
            }
        }
        FileUtil.close((OutputStream)output);
        this.cmSystem.update(propertiesFilePath);
        return;
    }

    private void removeAlwaysChangingProperties(WikiPageProperties properties) {
        properties.remove("LastModified");
    }

    protected WikiPage createChildPage(String name) {
        return new PageRepository().makeChildPage(name, this);
    }

    private void loadContent(PageData data) {
        String content = "";
        String name = this.getFileSystemPath() + contentFilename;
        File input = new File(name);
        try {
            if (input.exists()) {
                byte[] bytes = this.readContentBytes(input);
                content = new String(bytes, "UTF-8");
            }
            data.setContent(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading content", e);
        }
    }

    protected void loadChildren() {
        File thisDir = new File(this.getFileSystemPath());
        if (thisDir.exists()) {
            String[] subFiles;
            for (String subFile : subFiles = thisDir.list()) {
                if (!this.fileIsValid(subFile, thisDir) || this.children.containsKey(subFile)) continue;
                this.children.put(subFile, this.getChildPage(subFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContentBytes(File input) throws IOException {
        FileInputStream inputStream = null;
        try {
            byte[] bytes = new byte[(int)input.length()];
            inputStream = new FileInputStream(input);
            inputStream.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean fileIsValid(String filename, File dir) {
        File f;
        return WikiWordPath.isWikiWord((String)filename) && (f = new File(dir, filename)).isDirectory();
    }

    private String getParentFileSystemPath() {
        return this.parent != null ? ((FileSystemPage)this.parent).getFileSystemPath() : this.path;
    }

    public String getFileSystemPath() {
        return this.getParentFileSystemPath() + "/" + this.getName();
    }

    public String getAbsoluteFileSystemPath() {
        return new File(this.getFileSystemPath()).getAbsolutePath();
    }

    private void loadAttributes(PageData data) {
        File file = new File(this.getFileSystemPath() + propertiesFilename);
        if (file.exists()) {
            try {
                long lastModifiedTime = this.getLastModifiedTime();
                this.attemptToReadPropertiesFile(file, data, lastModifiedTime);
            }
            catch (Exception e) {
                System.err.println("Could not read properties file:" + file.getPath());
                e.printStackTrace();
            }
        }
    }

    private long getLastModifiedTime() {
        long lastModifiedTime = 0L;
        File file = new File(this.getFileSystemPath() + contentFilename);
        lastModifiedTime = file.exists() ? file.lastModified() : Clock.currentTimeInMillis();
        return lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void attemptToReadPropertiesFile(File file, PageData data, long lastModifiedTime) throws FileNotFoundException {
        FileInputStream input = null;
        try {
            WikiPageProperties props = new WikiPageProperties();
            input = new FileInputStream(file);
            props.loadFromXmlStream((InputStream)input);
            props.setLastModificationTime(new Date(lastModifiedTime));
            data.setProperties(props);
            if (input == null) return;
        }
        catch (Throwable throwable) {
            if (input == null) throw throwable;
            FileUtil.close(input);
            throw throwable;
        }
        FileUtil.close((InputStream)input);
    }

    public void doCommit(PageData data) {
        this.saveContent(data.getContent());
        this.saveAttributes(data.getProperties());
        this.versionsController.prune(this);
    }

    protected PageData makePageData() {
        PageData pagedata = new PageData((WikiPage)this);
        this.loadContent(pagedata);
        this.loadAttributes(pagedata);
        pagedata.addVersions(this.versionsController.history(this));
        return pagedata;
    }

    public PageData getDataVersion(String versionName) {
        return this.versionsController.getRevisionData(this, versionName);
    }

    private void createDirectoryIfNewPage(FileSystem fileSystem) {
        String pagePath = this.getFileSystemPath();
        if (!fileSystem.exists(pagePath)) {
            try {
                fileSystem.makeDirectory(pagePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory for new page", e);
            }
            this.cmSystem.update(pagePath);
        }
    }

    protected VersionInfo makeVersion() {
        PageData data = this.getData();
        return this.makeVersion(data);
    }

    protected VersionInfo makeVersion(PageData data) {
        return this.versionsController.makeVersion(this, data);
    }

    protected void removeVersion(String versionName) {
        this.versionsController.removeVersion(this, versionName);
    }

    public String toString() {
        try {
            return this.getClass().getName() + " at " + this.getFileSystemPath();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

