/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageCrawlerTest
implements TraversalListener<WikiPage> {
    private WikiPage root;
    private WikiPage page1;
    private WikiPage page2;
    private WikiPage child1;
    private WikiPage child2;
    private WikiPage grandChild1;
    private PageCrawlerImpl crawler;
    private WikiPagePath page1Path;
    private WikiPagePath child1FullPath;
    private WikiPagePath page2Path;
    private WikiPagePath grandChild1FullPath;
    Set<String> traversedPages = new HashSet();

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = new PageCrawlerImpl();
        this.page1Path = PathParser.parse((String)"PageOne");
        this.page2Path = PathParser.parse((String)"PageTwo");
        this.child1FullPath = PathParser.parse((String)"PageOne.ChildOne");
        this.grandChild1FullPath = PathParser.parse((String)"PageOne.ChildOne.GrandChildOne");
        this.page1 = this.crawler.addPage(this.root, this.page1Path);
        this.page2 = this.crawler.addPage(this.root, this.page2Path);
        this.child1 = this.crawler.addPage(this.page1, PathParser.parse((String)"ChildOne"));
        this.child2 = this.crawler.addPage(this.page1, PathParser.parse((String)"ChildTwo"));
        this.grandChild1 = this.crawler.addPage(this.child1, PathParser.parse((String)"GrandChildOne"));
    }

    @Test
    public void testPageExists() throws Exception {
        Assert.assertTrue((boolean)this.crawler.pageExists(this.page1, PathParser.parse((String)"ChildOne")));
        Assert.assertFalse((boolean)this.crawler.pageExists(this.page1, PathParser.parse((String)"BlahBlah")));
    }

    @Test
    public void testPageExistsUsingPath() throws Exception {
        Assert.assertTrue((boolean)this.crawler.pageExists(this.page1, PathParser.parse((String)"ChildOne")));
        Assert.assertTrue((boolean)this.crawler.pageExists(this.root, this.child1FullPath));
        Assert.assertTrue((boolean)this.crawler.pageExists(this.root, this.grandChild1FullPath));
        Assert.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)".PageOne")));
        Assert.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)".PageOne.ChildOne.GrandChildOne")));
        Assert.assertFalse((boolean)this.crawler.pageExists(this.page1, PathParser.parse((String)"BlahBlah")));
        Assert.assertFalse((boolean)this.crawler.pageExists(this.page1, PathParser.parse((String)"PageOne.BlahBlah")));
    }

    @Test
    public void testGetPage() throws Exception {
        Assert.assertEquals(null, (Object)this.crawler.getPage(this.page1, this.page1Path));
        Assert.assertEquals((Object)this.page1, (Object)this.crawler.getPage(this.root, this.page1Path));
        Assert.assertEquals((Object)this.page2, (Object)this.crawler.getPage(this.root, this.page2Path));
        Assert.assertEquals((Object)this.page1, (Object)this.crawler.getPage(this.page1, PathParser.parse((String)".PageOne")));
        Assert.assertEquals((Object)this.page1, (Object)this.crawler.getPage(this.grandChild1, PathParser.parse((String)".PageOne")));
        Assert.assertEquals((Object)this.grandChild1, (Object)this.crawler.getPage(this.page1, PathParser.parse((String)"ChildOne.GrandChildOne")));
        Assert.assertEquals((Object)this.root, (Object)this.crawler.getPage(this.root, PathParser.parse((String)"root")));
        Assert.assertEquals((Object)this.root, (Object)this.crawler.getPage(this.root, PathParser.parse((String)".")));
        Assert.assertEquals((Object)this.root, (Object)this.crawler.getPage(this.root, PathParser.parse((String)"")));
    }

    @Test
    public void testGetSiblingPage() throws Exception {
        Assert.assertEquals((Object)this.page2, (Object)this.crawler.getSiblingPage(this.page1, this.page2Path));
        Assert.assertEquals((Object)this.child1, (Object)this.crawler.getSiblingPage(this.page1, PathParser.parse((String)">ChildOne")));
        Assert.assertEquals((Object)this.child2, (Object)this.crawler.getSiblingPage(this.grandChild1, PathParser.parse((String)"<PageOne.ChildTwo")));
    }

    @Test
    public void testGetFullPath() throws Exception {
        Assert.assertEquals((Object)this.page1Path, (Object)this.crawler.getFullPath(this.page1));
        Assert.assertEquals((Object)this.page2Path, (Object)this.crawler.getFullPath(this.page2));
        Assert.assertEquals((Object)this.child1FullPath, (Object)this.crawler.getFullPath(this.child1));
        Assert.assertEquals((Object)this.grandChild1FullPath, (Object)this.crawler.getFullPath(this.grandChild1));
        Assert.assertEquals((Object)PathParser.parse((String)""), (Object)this.crawler.getFullPath(this.root));
    }

    @Test
    public void testGetAbsolutePathForChild() throws Exception {
        WikiPagePath somePagePath = PathParser.parse((String)"SomePage");
        WikiPagePath somePageFullPath = this.crawler.getFullPathOfChild(this.root, somePagePath);
        Assert.assertEquals((Object)"SomePage", (Object)PathParser.render((WikiPagePath)somePageFullPath));
        WikiPagePath pageOnePath = this.page1Path;
        WikiPagePath pageOneFullPath = this.crawler.getFullPathOfChild(this.root, pageOnePath);
        Assert.assertEquals((Object)"PageOne", (Object)PathParser.render((WikiPagePath)pageOneFullPath));
        WikiPagePath SomePageChildFullPath = this.crawler.getFullPathOfChild(this.child1, somePagePath);
        Assert.assertEquals((Object)"PageOne.ChildOne.SomePage", (Object)PathParser.render((WikiPagePath)SomePageChildFullPath));
        WikiPagePath otherPagePath = PathParser.parse((String)"SomePage.OtherPage");
        WikiPagePath otherPageFullPath = this.crawler.getFullPathOfChild(this.root, otherPagePath);
        Assert.assertEquals((Object)"SomePage.OtherPage", (Object)PathParser.render((WikiPagePath)otherPageFullPath));
        WikiPagePath somePageAbsolutePath = PathParser.parse((String)".SomePage");
        WikiPagePath somePageAbsoluteFullPath = this.crawler.getFullPathOfChild(this.child1, somePageAbsolutePath);
        Assert.assertEquals((Object)"SomePage", (Object)PathParser.render((WikiPagePath)somePageAbsoluteFullPath));
    }

    @Test
    public void testAddPage() throws Exception {
        WikiPage page = this.crawler.addPage(this.page1, PathParser.parse((String)"SomePage"));
        Assert.assertEquals((Object)PathParser.parse((String)"PageOne.SomePage"), (Object)this.crawler.getFullPath(page));
        Assert.assertEquals((Object)this.page1, (Object)page.getParent());
    }

    @Test
    public void testRecursiveAddbyName() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"AaAa"), "its content");
        Assert.assertTrue((boolean)this.root.hasChildPage("AaAa"));
        this.crawler.addPage(this.root, PathParser.parse((String)"AaAa.BbBb"), "floop");
        Assert.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"AaAa.BbBb")));
        Assert.assertEquals((Object)"floop", (Object)this.crawler.getPage(this.root, PathParser.parse((String)"AaAa.BbBb")).getData().getContent());
    }

    @Test
    public void testAddChildPageWithMissingParent() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"WikiMail.BadSubject0123"), "");
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((Object)"BadSubject0123", (Object)page.getName());
        Assert.assertEquals((Object)PathParser.parse((String)"WikiMail.BadSubject0123"), (Object)this.crawler.getFullPath(page));
    }

    @Test
    public void testGetRelativePageName() throws Exception {
        Assert.assertEquals((Object)"PageOne", (Object)this.crawler.getRelativeName(this.root, this.page1));
        Assert.assertEquals((Object)"PageOne.ChildOne", (Object)this.crawler.getRelativeName(this.root, this.child1));
        Assert.assertEquals((Object)"ChildOne", (Object)this.crawler.getRelativeName(this.page1, this.child1));
        Assert.assertEquals((Object)"GrandChildOne", (Object)this.crawler.getRelativeName(this.child1, this.grandChild1));
        Assert.assertEquals((Object)"ChildOne.GrandChildOne", (Object)this.crawler.getRelativeName(this.page1, this.grandChild1));
    }

    @Test
    public void testIsRoot() throws Exception {
        Assert.assertTrue((boolean)this.crawler.isRoot(this.root));
        WikiPage page = this.crawler.addPage(this.root, this.page1Path);
        Assert.assertFalse((boolean)this.crawler.isRoot(page));
    }

    @Test
    public void testTraversal() throws Exception {
        this.crawler.traverse(this.root, (TraversalListener)this);
        Assert.assertEquals((long)6L, (long)this.traversedPages.size());
        Assert.assertTrue((boolean)this.traversedPages.contains("PageOne"));
        Assert.assertTrue((boolean)this.traversedPages.contains("ChildOne"));
    }

    public void process(WikiPage page) {
        this.traversedPages.add(page.getName());
    }

    @Test
    public void testdoesntTraverseSymbolicPages() throws Exception {
        PageData data = this.page1.getData();
        data.getProperties().set("SymbolicLinks").set("SymLink", "PageTwo");
        this.page1.commit(data);
        this.crawler.traverse(this.root, (TraversalListener)this);
        Assert.assertEquals((long)6L, (long)this.traversedPages.size());
        Assert.assertFalse((boolean)this.traversedPages.contains("SymLink"));
    }

    @Test
    public void canFindAllUncles() throws Exception {
        WikiPage grandUnclePage = this.crawler.addPage(this.root, PathParser.parse((String)"UnclePage"));
        WikiPage unclePage = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.UnclePage"));
        WikiPage brotherPage = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.ChildOne.UnclePage"));
        List uncles = PageCrawlerImpl.getAllUncles((String)"UnclePage", (WikiPage)this.grandChild1);
        Assert.assertTrue((boolean)uncles.contains(grandUnclePage));
        Assert.assertTrue((boolean)uncles.contains(unclePage));
        Assert.assertTrue((boolean)uncles.contains(brotherPage));
    }
}

