/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.MockXmlizerPageHandler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageXmlizer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.XmlizePageCondition;
import fitnesse.wiki.XmlizerPageHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import util.RegexTestCase;
import util.XmlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageXmlizerTest
extends RegexTestCase {
    private PageXmlizer xmlizer;
    private WikiPage root;
    private PageCrawler crawler;
    private SimpleDateFormat format = WikiPageProperty.getTimeFormat();

    public void setUp() throws Exception {
        this.xmlizer = new PageXmlizer();
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
    }

    public void tearDown() throws Exception {
    }

    public void testXmlizeOneWikiPage() throws Exception {
        Document doc = this.xmlizer.xmlize(this.root);
        String value = XmlUtil.xmlAsString((Document)doc);
        PageXmlizerTest.assertSubString((String)"<page>", (String)value);
        PageXmlizerTest.assertSubString((String)"</page>", (String)value);
        PageXmlizerTest.assertSubString((String)"<name>RooT</name>", (String)value);
        this.checkForLastModifiedTag(this.root, value);
    }

    private void checkForLastModifiedTag(WikiPage page, String value) throws Exception {
        Date lastModificationTime = page.getData().getProperties().getLastModificationTime();
        String timeString = WikiPageProperties.getTimeFormat().format(lastModificationTime);
        PageXmlizerTest.assertSubString((String)("<lastModified>" + timeString + "</lastModified>"), (String)value);
    }

    public void testDeXmlizeOneWikiPage() throws Exception {
        Document doc = this.xmlizer.xmlize(this.root);
        this.xmlizer.deXmlize(doc, this.root, (XmlizerPageHandler)new MockXmlizerPageHandler());
        List children = this.root.getChildren();
        PageXmlizerTest.assertEquals((int)1, (int)children.size());
        WikiPage page = (WikiPage)children.get(0);
        PageXmlizerTest.assertEquals((String)"RooT", (String)page.getName());
    }

    public void testXmlizeTwoPages() throws Exception {
        WikiPage pageOne = this.root.addChildPage("PageOne");
        Document doc = this.xmlizer.xmlize(this.root);
        String value = XmlUtil.xmlAsString((Document)doc);
        PageXmlizerTest.assertSubString((String)"<name>RooT</name>", (String)value);
        PageXmlizerTest.assertSubString((String)"<name>PageOne</name>", (String)value);
        this.checkForLastModifiedTag(this.root, value);
        this.checkForLastModifiedTag(pageOne, value);
    }

    public void testDeXmlizingTwoPages() throws Exception {
        this.root.addChildPage("PageOne");
        this.xmlizer.deXmlize(this.xmlizer.xmlize(this.root), this.root, (XmlizerPageHandler)new MockXmlizerPageHandler());
        PageXmlizerTest.assertEquals((int)2, (int)this.root.getChildren().size());
        WikiPage marshaledRoot = this.root.getChildPage("RooT");
        PageXmlizerTest.assertNotNull((Object)marshaledRoot);
        PageXmlizerTest.assertEquals((int)1, (int)marshaledRoot.getChildren().size());
        PageXmlizerTest.assertNotNull((Object)marshaledRoot.getChildPage("PageOne"));
    }

    public void testXmlizingAnEntireTree() throws Exception {
        this.makeFamilyOfPages();
        Document doc = this.xmlizer.xmlize(this.root);
        String value = XmlUtil.xmlAsString((Document)doc);
        PageXmlizerTest.assertSubString((String)"PageA", (String)value);
        PageXmlizerTest.assertSubString((String)"ChildOneA", (String)value);
        PageXmlizerTest.assertSubString((String)"GrandChildA", (String)value);
        PageXmlizerTest.assertSubString((String)"GreatGrandChildA", (String)value);
        PageXmlizerTest.assertSubString((String)"ChildTwoA", (String)value);
        PageXmlizerTest.assertSubString((String)"GrandChildTwoA", (String)value);
        PageXmlizerTest.assertSubString((String)"PageB", (String)value);
        PageXmlizerTest.assertSubString((String)"ChildOneB", (String)value);
        PageXmlizerTest.assertSubString((String)"GrandChildB", (String)value);
        PageXmlizerTest.assertSubString((String)"PageC", (String)value);
    }

    public void testDeXmlizingEntireTree() throws Exception {
        this.makeFamilyOfPages();
        this.xmlizer.deXmlize(this.xmlizer.xmlize(this.root), this.root, (XmlizerPageHandler)new MockXmlizerPageHandler());
        PageXmlizerTest.assertEquals((int)4, (int)this.root.getChildren().size());
        WikiPage marshaledRoot = this.root.getChildPage("RooT");
        PageXmlizerTest.assertEquals((int)3, (int)marshaledRoot.getChildren().size());
        WikiPage pageA = marshaledRoot.getChildPage("PageA");
        PageXmlizerTest.assertEquals((int)2, (int)pageA.getChildren().size());
        WikiPage childOneA = pageA.getChildPage("ChildOneA");
        WikiPage grandChildA = childOneA.getChildPage("GrandChildA");
        WikiPage greatGrandChildA = grandChildA.getChildPage("GreatGrandChildA");
        PageXmlizerTest.assertNotNull((Object)greatGrandChildA);
        PageXmlizerTest.assertNotNull((Object)this.getPage("RooT.PageB.ChildOneB.GrandChildB"));
        PageXmlizerTest.assertNotNull((Object)this.getPage("RooT.PageC"));
    }

    public void testDeXmlizeEntireTreeTwice() throws Exception {
        this.makeFamilyOfPages();
        Document doc = this.xmlizer.xmlize(this.root);
        this.xmlizer.deXmlize(doc, this.root, (XmlizerPageHandler)new MockXmlizerPageHandler());
        this.xmlizer.deXmlize(doc, this.root, (XmlizerPageHandler)new MockXmlizerPageHandler());
        PageXmlizerTest.assertEquals((int)4, (int)this.root.getChildren().size());
        WikiPage marshaledRoot = this.root.getChildPage("RooT");
        PageXmlizerTest.assertEquals((int)3, (int)marshaledRoot.getChildren().size());
        WikiPage pageA = marshaledRoot.getChildPage("PageA");
        PageXmlizerTest.assertEquals((int)2, (int)pageA.getChildren().size());
    }

    public void testDeXmlizeSkippingRootLevel() throws Exception {
        this.makeFamilyOfPages();
        WikiPage pageC = this.root.getChildPage("PageC");
        this.xmlizer.deXmlizeSkippingRootLevel(this.xmlizer.xmlize(this.root), pageC, (XmlizerPageHandler)new MockXmlizerPageHandler());
        PageXmlizerTest.assertEquals((int)3, (int)pageC.getChildren().size());
        WikiPage pageA = pageC.getChildPage("PageA");
        PageXmlizerTest.assertEquals((int)2, (int)pageA.getChildren().size());
        WikiPage childOneA = pageA.getChildPage("ChildOneA");
        WikiPage grandChildA = childOneA.getChildPage("GrandChildA");
        WikiPage greatGrandChildA = grandChildA.getChildPage("GreatGrandChildA");
        PageXmlizerTest.assertNotNull((Object)greatGrandChildA);
        PageXmlizerTest.assertNotNull((Object)this.crawler.getPage(pageC, PathParser.parse((String)"PageB.ChildOneB.GrandChildB")));
        PageXmlizerTest.assertNotNull((Object)this.crawler.getPage(pageC, PathParser.parse((String)"PageC")));
    }

    public void testUsageOfHandler() throws Exception {
        this.makeFamilyOfPages();
        MockXmlizerPageHandler handler = new MockXmlizerPageHandler();
        this.xmlizer.deXmlize(this.xmlizer.xmlize(this.root), this.root, (XmlizerPageHandler)handler);
        PageXmlizerTest.assertEquals((int)11, (int)handler.handledPages.size());
        this.checkPageWasHandledWithRightDate(0, this.root, handler);
        this.checkPageWasHandledWithRightDate(1, this.getPage("PageA"), handler);
        this.checkPageWasHandledWithRightDate(2, this.getPage("PageA.ChildOneA"), handler);
        this.checkPageWasHandledWithRightDate(3, this.getPage("PageA.ChildOneA.GrandChildA"), handler);
        this.checkPageWasHandledWithRightDate(4, this.getPage("PageA.ChildOneA.GrandChildA.GreatGrandChildA"), handler);
        this.checkPageWasHandledWithRightDate(5, this.getPage("PageA.ChildTwoA"), handler);
        this.checkPageWasHandledWithRightDate(6, this.getPage("PageA.ChildTwoA.GrandChildTwoA"), handler);
        this.checkPageWasHandledWithRightDate(7, this.getPage("PageB"), handler);
        this.checkPageWasHandledWithRightDate(8, this.getPage("PageB.ChildOneB"), handler);
        this.checkPageWasHandledWithRightDate(9, this.getPage("PageB.ChildOneB.GrandChildB"), handler);
        this.checkPageWasHandledWithRightDate(10, this.getPage("PageC"), handler);
        PageXmlizerTest.assertEquals((int)11, (int)handler.exits);
    }

    private WikiPage getPage(String pathName) throws Exception {
        return this.crawler.getPage(this.root, PathParser.parse((String)pathName));
    }

    private void checkPageWasHandledWithRightDate(int i, WikiPage page, MockXmlizerPageHandler handler) throws Exception {
        PageXmlizerTest.assertEquals((String)page.getName(), (String)((String)handler.handledPages.get(i)));
        String actualModifyTime = this.format.format(page.getData().getProperties().getLastModificationTime());
        String listedModifyTime = this.format.format((Date)handler.modDates.get(i));
        PageXmlizerTest.assertEquals((String)actualModifyTime, (String)listedModifyTime);
    }

    private void makeFamilyOfPages() throws Exception {
        this.addPage("PageA", "page a");
        this.addPage("PageA.ChildOneA", "child one a");
        this.addPage("PageA.ChildOneA.GrandChildA", "grand child a");
        this.addPage("PageA.ChildOneA.GrandChildA.GreatGrandChildA", "great grand child a");
        this.addPage("PageA.ChildTwoA", "child two a");
        this.addPage("PageA.ChildTwoA.GrandChildTwoA", "grand child two a");
        this.addPage("PageB", "page b");
        this.addPage("PageB.ChildOneB", "child one b");
        this.addPage("PageB.ChildOneB.GrandChildB", "grand child b");
        this.addPage("PageC", "page c");
    }

    private void addPage(String path, String content) throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)path), content);
    }

    public void testXmlizingData() throws Exception {
        PageData data = new PageData(this.root);
        data.setContent("this is some content.");
        WikiPageProperties properties = data.getProperties();
        Document doc = this.xmlizer.xmlize(data);
        String marshaledValue = XmlUtil.xmlAsString((Document)doc);
        PageXmlizerTest.assertSubString((String)"<data>", (String)marshaledValue);
        PageXmlizerTest.assertSubString((String)"CDATA", (String)marshaledValue);
        PageXmlizerTest.assertSubString((String)"this is some content", (String)marshaledValue);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.save((OutputStream)output);
        String[] propertyLines = output.toString().split("\n");
        for (int i = 0; i < propertyLines.length; ++i) {
            String propertyLine = propertyLines[i].trim();
            PageXmlizerTest.assertSubString((String)propertyLine, (String)marshaledValue);
        }
    }

    public void testDeXmlizingPageData() throws Exception {
        PageData data = new PageData(this.root);
        data.setContent("this is some content.");
        WikiPageProperties properties = data.getProperties();
        PageData receivedData = this.xmlizer.deXmlizeData(this.xmlizer.xmlize(data));
        PageXmlizerTest.assertNotSame((Object)data, (Object)receivedData);
        PageXmlizerTest.assertEquals((String)"this is some content.", (String)receivedData.getContent());
        WikiPageProperties receivedProperties = receivedData.getProperties();
        PageXmlizerTest.assertNotSame((Object)properties, (Object)receivedProperties);
        PageXmlizerTest.assertEquals((String)properties.toString(), (String)receivedProperties.toString());
    }

    public void testConditionForXmlization() throws Exception {
        WikiPage pageOne = this.root.addChildPage("PageOne");
        WikiPage pageTwo = this.root.addChildPage("PageTwo");
        this.xmlizer.addPageCondition((XmlizePageCondition)new /* Unavailable Anonymous Inner Class!! */);
        Document doc = this.xmlizer.xmlize(this.root);
        String value = XmlUtil.xmlAsString((Document)doc);
        PageXmlizerTest.assertSubString((String)"<name>RooT</name>", (String)value);
        PageXmlizerTest.assertSubString((String)"<name>PageOne</name>", (String)value);
        PageXmlizerTest.assertNotSubString((String)"PageTwo", (String)value);
        this.checkForLastModifiedTag(this.root, value);
        this.checkForLastModifiedTag(pageOne, value);
    }
}

