/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.RawHtml;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

/*
 * Exception performing whole class analysis ignored.
 */
public class Collapsible
extends SymbolType
implements Rule,
Translation {
    private static final String STATE = "State";
    public static final String CLOSED = " closed";
    private static final String INVISIBLE = " invisible";

    public Collapsible() {
        super("Collapsible");
        this.wikiMatcher(new Matcher().startLine().string("!").repeat('*'));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String state = "";
        Symbol next = parser.moveNext(1);
        if (next.getContent().equals(">")) {
            state = " closed";
            next = parser.moveNext(1);
        } else if (next.getContent().equals("<")) {
            state = " invisible";
            next = parser.moveNext(1);
        }
        if (!next.isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        Symbol titleText = parser.parseToIgnoreFirst(SymbolType.Newline);
        if (parser.atEnd()) {
            return Symbol.nothing;
        }
        Symbol bodyText = parser.parseTo(SymbolType.CloseCollapsible);
        if (parser.atEnd()) {
            return Symbol.nothing;
        }
        return new Maybe((Object)current.putProperty("State", state).add(titleText).add(bodyText));
    }

    public String toTarget(Translator translator, Symbol symbol) {
        String option = symbol.getProperty("State");
        String title = translator.translate(symbol.childAt(0));
        String body = translator.translate(symbol.childAt(1));
        return Collapsible.generateHtml((String)option, (String)title, (String)body);
    }

    private String makeInvisibleSection(String body) {
        HtmlTag section = new HtmlTag("div", body);
        section.addAttribute("class", "invisible");
        return section.html();
    }

    public static String generateHtml(String state, String titleText, String bodyText) {
        HtmlTag outerBlock = new HtmlTag("div");
        outerBlock.addAttribute("class", "collapsible" + state);
        outerBlock.add((HtmlElement)new RawHtml("<ul><li><a href='#' class='expandall'>Expand All</a></li><li><a href='#' class='collapseall'>Collapse All</a></li></ul>"));
        HtmlTag title = new HtmlTag("p", titleText);
        title.addAttribute("class", "title");
        outerBlock.add((HtmlElement)title);
        HtmlTag body = new HtmlTag("div", bodyText);
        outerBlock.add((HtmlElement)body);
        return outerBlock.html();
    }
}

