/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;

public class ParsedPage {
    private final String content;
    private final ParsingPage parsingPage;
    private Symbol syntaxTree = null;

    public ParsedPage(SourcePage sourcePage, String content) {
        this.parsingPage = new ParsingPage(sourcePage);
        this.content = content;
    }

    public ParsedPage(ParsedPage sourceParsedPage, String content) {
        this.parsingPage = sourceParsedPage.getParsingPage().copy();
        this.content = content;
    }

    public Symbol getSyntaxTree() {
        this.parseContent();
        return this.syntaxTree;
    }

    public ParsingPage getParsingPage() {
        this.parseContent();
        return this.parsingPage;
    }

    public void addToFront(ParsedPage addFromPage) {
        this.getSyntaxTree().addToFront(addFromPage.getSyntaxTree().childAt(0));
    }

    public String toHtml() {
        return new HtmlTranslator(this.getParsingPage().getPage(), this.getParsingPage()).translateTree(this.getSyntaxTree());
    }

    private void parseContent() {
        if (this.syntaxTree == null) {
            this.syntaxTree = Parser.make((ParsingPage)this.parsingPage, (String)this.content).parse();
        }
    }
}

