/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolStream;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.TextMaker;
import fitnesse.wikitext.parser.VariableSource;
import java.util.ArrayList;
import java.util.List;
import util.Maybe;

public class Scanner {
    private ScanString input;
    private int next;
    private TextMaker textMaker;
    private SymbolStream symbols;

    public Scanner(SourcePage sourcePage, String input) {
        this(new TextMaker((VariableSource)new /* Unavailable Anonymous Inner Class!! */, sourcePage), input);
    }

    public Scanner(TextMaker textMaker, String input) {
        this.input = new ScanString(input, 0);
        this.next = 0;
        this.textMaker = textMaker;
        this.symbols = new SymbolStream();
    }

    public Scanner(Scanner other) {
        this.copy(other);
    }

    public int getOffset() {
        return this.next;
    }

    public void markStart() {
        this.input.markStart(this.next);
    }

    public boolean isEnd() {
        return this.symbols.isEnd();
    }

    public Symbol getCurrent() {
        return this.symbols.get(0);
    }

    public Maybe<String> stringFromStart(int start) {
        int end = this.getOffset() - this.getCurrent().getContent().length();
        return start <= end ? new Maybe((Object)this.input.rawSubstring(start, end)) : Maybe.noString;
    }

    public void copy(Scanner other) {
        this.input = new ScanString(other.input);
        this.next = other.next;
        this.textMaker = other.textMaker;
        this.symbols = new SymbolStream(other.symbols);
    }

    public Symbol makeLiteral(SymbolType terminator) {
        this.input.setOffset(this.next);
        while (!this.input.isEnd()) {
            SymbolMatch match = terminator.makeMatch(this.input, this.symbols);
            if (match.isMatch()) {
                this.symbols.add(new Symbol(terminator));
                Symbol result = new Symbol(SymbolType.Text, this.input.substringFrom(this.next));
                this.next = this.input.getOffset() + match.getMatchLength();
                return result;
            }
            this.input.moveNext();
        }
        Symbol result = new Symbol(SymbolType.Text, this.input.substringFrom(this.next));
        this.next = this.input.getOffset();
        this.symbols.add(Symbol.emptySymbol);
        return result;
    }

    public void moveNext() {
        this.moveNextIgnoreFirst(new ParseSpecification());
    }

    public void moveNextIgnoreFirst(ParseSpecification specification) {
        Step step = this.makeNextStep(specification, this.next);
        this.next = step.nextPosition;
        this.symbols.add(step.token);
    }

    public List<Symbol> peek(int count, ParseSpecification specification) {
        ArrayList<Symbol> result = new ArrayList<Symbol>(count);
        int startPosition = this.next;
        for (int i = 0; i < count; ++i) {
            Step step = this.makeNextStep(specification, startPosition);
            result.add(step.token);
            if (this.input.isEnd()) break;
            startPosition = step.nextPosition;
        }
        return result;
    }

    private Step makeNextStep(ParseSpecification specification, int startPosition) {
        SymbolMatch match;
        this.input.setOffset(startPosition);
        int newNext = startPosition;
        Symbol matchSymbol = null;
        while (!this.input.isEnd()) {
            match = specification.findMatch(this.input, startPosition, this.symbols);
            if (match.isMatch()) {
                matchSymbol = match.getSymbol();
                newNext = this.input.getOffset() + match.getMatchLength();
                break;
            }
            this.input.moveNext();
        }
        if (this.input.getOffset() > startPosition) {
            match = this.textMaker.make(specification, this.input.substringFrom(startPosition));
            return new Step(this, match.getSymbol(), startPosition + match.getMatchLength());
        }
        if (this.input.isEnd()) {
            return new Step(this, Symbol.emptySymbol, this.input.getOffset());
        }
        return new Step(this, matchSymbol, newNext);
    }
}

