/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.SourcePage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import util.Maybe;
import util.StringUtil;

public class WikiSourcePage
implements SourcePage {
    private WikiPage page;

    public WikiSourcePage(WikiPage page) {
        this.page = page;
    }

    public String getName() {
        return this.page.getName();
    }

    public String getFullName() {
        try {
            return this.page.getPageCrawler().getFullPath(this.page).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        try {
            return this.page.getPageCrawler().getFullPath(this.page).parentPath().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getFullPath() {
        try {
            return this.page.getPageCrawler().getFullPath(this.page).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getContent() {
        try {
            return this.page.getData().getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean targetExists(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse((String)wikiWordPath);
        try {
            WikiPage parentPage = this.page.getParent();
            return parentPage.getPageCrawler().getPage(parentPage, pathOfWikiWord) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String makeFullPathOfTarget(String wikiWordPath) {
        WikiPagePath pathOfWikiWord = PathParser.parse((String)wikiWordPath);
        if (pathOfWikiWord == null) {
            throw new IllegalArgumentException("Can't parse path: " + wikiWordPath);
        }
        try {
            WikiPage parentPage = this.page.getParent();
            return PathParser.render((WikiPagePath)parentPage.getPageCrawler().getFullPathOfChild(parentPage, pathOfWikiWord));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String findParentPath(String targetName) {
        String[] pathElements = targetName.split("\\.");
        String target = pathElements[0];
        PageCrawler crawler = this.page.getPageCrawler();
        try {
            WikiPage ancestor = crawler.findAncestorWithName(this.page, target);
            if (ancestor != null) {
                pathElements[0] = PathParser.render((WikiPagePath)crawler.getFullPath(ancestor));
                return "." + StringUtil.join(Arrays.asList(pathElements), (String)".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return "." + targetName;
    }

    public Maybe<SourcePage> findIncludedPage(String pageName) {
        PageCrawler crawler = this.page.getPageCrawler();
        WikiPagePath pagePath = PathParser.parse((String)pageName);
        if (pagePath == null) {
            return Maybe.nothingBecause((String)("Page include failed because the page " + pageName + " does not have a valid WikiPage name.\n"));
        }
        try {
            WikiPage includedPage = crawler.getSiblingPage(this.page, pagePath);
            if (includedPage == null) {
                if (this.page instanceof ProxyPage) {
                    ProxyPage proxy = (ProxyPage)this.page;
                    String host = proxy.getHost();
                    int port = proxy.getHostPort();
                    try {
                        ProxyPage remoteIncludedPage = new ProxyPage("RemoteIncludedPage", null, host, port, pagePath);
                        return new Maybe((Object)new WikiSourcePage((WikiPage)remoteIncludedPage));
                    }
                    catch (Exception e) {
                        return Maybe.nothingBecause((String)"Remote page \" + host + \":\" + port + \"/\" + pageName + \" does not exist.\n");
                    }
                }
                return Maybe.nothingBecause((String)("Page include failed because the page " + pageName + " does not exist.\n"));
            }
            if (this.isParentOf(includedPage)) {
                return Maybe.nothingBecause((String)("Error! Cannot include parent page (" + pageName + ").\n"));
            }
            return new Maybe((Object)new WikiSourcePage(includedPage));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Collection<SourcePage> getAncestors() {
        ArrayList<SourcePage> ancestors = new ArrayList<SourcePage>();
        try {
            for (WikiPage ancestor = this.page.getParent(); ancestor != null && ancestor != this.page; ancestor = ancestor.getParent()) {
                ancestors.add((SourcePage)new WikiSourcePage(ancestor));
                if (!ancestor.getPageCrawler().isRoot(ancestor)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return ancestors;
    }

    public Collection<SourcePage> getChildren() {
        ArrayList<SourcePage> children = new ArrayList<SourcePage>();
        try {
            for (WikiPage child : this.page.getChildren()) {
                children.add((SourcePage)new WikiSourcePage(child));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return children;
    }

    public boolean hasProperty(String propertyKey) {
        try {
            return this.page.getData().getProperties().has(propertyKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getProperty(String propertyKey) {
        try {
            String propertyValue = this.page.getData().getAttribute(propertyKey);
            return propertyValue != null ? propertyValue.trim() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String makeUrl(String wikiWordPath) {
        if (!(this.page instanceof ProxyPage)) {
            return this.makeFullPathOfTarget(wikiWordPath);
        }
        ProxyPage proxy = (ProxyPage)this.page;
        String remoteURLOfPage = proxy.getThisPageUrl();
        String nameOfThisPage = proxy.getName();
        int startOfThisPageName = remoteURLOfPage.lastIndexOf(nameOfThisPage);
        String remoteURLOfParent = remoteURLOfPage.substring(0, startOfThisPageName);
        return remoteURLOfParent + wikiWordPath;
    }

    private boolean isParentOf(WikiPage possibleParent) {
        try {
            for (WikiPage candidate = this.page; candidate.getParent() != candidate; candidate = candidate.getParent()) {
                if (possibleParent != candidate) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public int compareTo(SourcePage other) {
        return this.getName().compareTo(other.getName());
    }
}

