/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import fitnesse.wikitext.test.TestSourcePage;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Test;

public class AliasTest {
    @Test
    public void scansAliases() {
        ParserTestHelper.assertScansTokenType((String)"[[tag][link]]", (String)"Alias", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"[ [tag][link]]", (String)"Alias", (boolean)false);
    }

    @Test
    public void parsesAliases() throws Exception {
        ParserTestHelper.assertParses((String)"[[tag][PageOne]]", (String)"SymbolList[Alias[SymbolList[Text], SymbolList[Text]]]");
        ParserTestHelper.assertParses((String)"[[PageOne][PageOne]]", (String)"SymbolList[Alias[SymbolList[WikiWord], SymbolList[Text]]]");
        ParserTestHelper.assertParses((String)"[[PageOne][PageOne?edit]]", (String)"SymbolList[Alias[SymbolList[WikiWord], SymbolList[Text]]]");
    }

    @Test
    public void translatesAliases() throws Exception {
        TestSourcePage page = new TestSourcePage().withTarget("PageOne");
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[tag][link]]", (String)this.link("tag", "link"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[tag][#anchor]]", (String)this.link("tag", "#anchor"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[tag][PageOne]]", (String)this.link("tag", "PageOne"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[''tag''][PageOne]]", (String)this.link("<i>tag</i>", "PageOne"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[you're it][PageOne]]", (String)this.link("you're it", "PageOne"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[PageOne][IgnoredPage]]", (String)this.link("PageOne", "PageOne"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[tag][PageOne?edit]]", (String)this.link("tag", "PageOne?edit"));
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)"[[tag][http://files/myfile]]", (String)this.link("tag", "/files/myfile"));
    }

    @Test
    public void translatesLinkToNonExistent() {
        ParserTestHelper.assertTranslatesTo((SourcePage)new TestSourcePage().withUrl("NonExistentPage"), (String)"[[tag][NonExistentPage]]", (String)"tag<a title=\"create page\" href=\"NonExistentPage?edit&amp;nonExistent=true\">[?]</a>");
    }

    @Test
    public void evaluatesVariablesInLink() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage page = root.makePage("PageOne", "[[tag][PageTwo${x}]]");
        root.makePage("PageTwo3", "hi");
        ParserTestHelper.assertTranslatesTo((WikiPage)page, (VariableSource)new TestVariableSource("x", "3"), (String)this.link("tag", "PageTwo3"));
    }

    private String link(String body, String href) {
        return "<a href=\"" + href + "\">" + body + "</a>";
    }
}

