/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class AnchorNameTest {
    @Test
    public void scansAnchors() {
        ParserTestHelper.assertScansTokenType((String)"!anchor name", (String)"AnchorName", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"! anchor name", (String)"AnchorName", (boolean)false);
    }

    @Test
    public void parsesAnchors() throws Exception {
        ParserTestHelper.assertParses((String)"!anchor name", (String)"SymbolList[AnchorName[Text]]");
        ParserTestHelper.assertParses((String)"!anchor 1234", (String)"SymbolList[AnchorName[Text]]");
        ParserTestHelper.assertParses((String)"!anchor @#$@#%", (String)"SymbolList[Text, Whitespace, Text]");
        ParserTestHelper.assertParses((String)"!anchorname", (String)"SymbolList[Text]");
    }

    @Test
    public void translatesAnchors() {
        ParserTestHelper.assertTranslatesTo((String)"!anchor name", (String)this.anchorWithName("name"));
        ParserTestHelper.assertTranslatesTo((String)"!anchor name stuff", (String)(this.anchorWithName("name") + " stuff"));
        ParserTestHelper.assertTranslatesTo((String)"more!anchor name stuff", (String)("more" + this.anchorWithName("name") + " stuff"));
        ParserTestHelper.assertTranslatesTo((String)"more !anchor name stuff", (String)("more " + this.anchorWithName("name") + " stuff"));
    }

    private String anchorWithName(String name) {
        return "<a name=\"" + name + "\"> </a>";
    }
}

