/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class AnchorReferenceTest {
    @Test
    public void scansAnchors() {
        ParserTestHelper.assertScansTokenType((String)".#anchorName", (String)"AnchorReference", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)".# anchorName", (String)"AnchorReference", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)". #anchor Name", (String)"AnchorReference", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"blah.#anchorName", (String)"AnchorReference", (boolean)true);
    }

    @Test
    public void translatesAnchors() {
        ParserTestHelper.assertTranslatesTo((String)".#anchorName", (String)this.anchorReferenceWithName("anchorName"));
        ParserTestHelper.assertTranslatesTo((String)".# anchorName", (String)".# anchorName");
        ParserTestHelper.assertTranslatesTo((String)".#anchorName stuff", (String)(this.anchorReferenceWithName("anchorName") + " stuff"));
        ParserTestHelper.assertTranslatesTo((String)"more.#anchorName stuff", (String)("more" + this.anchorReferenceWithName("anchorName") + " stuff"));
        ParserTestHelper.assertTranslatesTo((String)"more\n.#anchorName stuff", (String)("more<br/>" + this.anchorReferenceWithName("anchorName") + " stuff"));
    }

    private String anchorReferenceWithName(String name) {
        return "<a href=\"#" + name + "\">.#" + name + "</a>" + HtmlElement.endl;
    }
}

