/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class CollapsibleTest {
    @Test
    public void scansCollapsible() {
        ParserTestHelper.assertScansTokenType((String)"!* title\ncontent\n*!", (String)"Collapsible", (boolean)true);
    }

    @Test
    public void parsesCollapsible() throws Exception {
        ParserTestHelper.assertParses((String)"!* title\ncontent\n*!", (String)"SymbolList[Collapsible[SymbolList[Text], SymbolList[Text, Newline]]]");
        ParserTestHelper.assertParses((String)"!* title\n\n*!", (String)"SymbolList[Collapsible[SymbolList[Text], SymbolList[Newline]]]");
        ParserTestHelper.assertParses((String)"!**\n**!", (String)"SymbolList[Text, Newline, CloseCollapsible]");
        ParserTestHelper.assertParses((String)"!* title\n!path x\n**!", (String)"SymbolList[Collapsible[SymbolList[Text], SymbolList[Path[SymbolList[Text]], Newline]]]");
    }

    @Test
    public void translatesCollapsible() {
        ParserTestHelper.assertTranslatesTo((String)"!* Some title\n''content''\n*!", (String)this.sectionWithClass("collapsible", "<i>content</i><br/>"));
        ParserTestHelper.assertTranslatesTo((String)"!* Some title\n\n*!", (String)this.sectionWithClass("collapsible", "<br/>"));
        ParserTestHelper.assertTranslatesTo((String)"!*> Some title\n content \n*!", (String)this.sectionWithClass("collapsible closed", " content <br/>"));
        ParserTestHelper.assertTranslatesTo((String)"!*< Some title\n content \n*!", (String)this.sectionWithClass("collapsible invisible", " content <br/>"));
    }

    private String sectionWithClass(String sectionClasses, String content) {
        return "<div class=\"" + sectionClasses + "\">" + "<ul>" + "<li><a href='#' class='expandall'>Expand All</a></li>" + "<li><a href='#' class='collapseall'>Collapse All</a></li>" + "</ul>" + HtmlElement.endl + "\t<p class=\"title\">Some title</p>" + HtmlElement.endl + "\t<div>" + content + "</div>" + HtmlElement.endl + "</div>" + HtmlElement.endl;
    }
}

