/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Test;

public class HelpTest {
    @Test
    public void parsesHelp() throws Exception {
        ParserTestHelper.assertParses((String)"!help", (String)"SymbolList[Help]");
        ParserTestHelper.assertParses((String)"!help -editable", (String)"SymbolList[Help]");
        ParserTestHelper.assertParses((String)"!help -garbage", (String)"SymbolList[Help, Whitespace, Text]");
    }

    @Test
    public void translatesHelp() throws Exception {
        this.assertTranslates("help me", "!help", "Help");
        this.assertTranslates("", "!help", "Suites");
        this.assertTranslates("help me <a href=\"TestHelp?properties\">(edit)</a>", "!help -editable", "Help");
        this.assertTranslates(" <a href=\"TestHelp?properties\">(edit help text)</a>", "!help -editable", "Suites");
    }

    private void assertTranslates(String expected, String content, String property) throws Exception {
        WikiPage pageWithHelp = new TestRoot().makePage("TestHelp", content);
        PageData pageData = pageWithHelp.getData();
        pageData.setAttribute(property, "help me");
        pageWithHelp.commit(pageData);
        ParserTestHelper.assertTranslatesTo((WikiPage)pageWithHelp, (String)expected);
    }
}

