/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Assert;
import org.junit.Test;

public class VariableTest {
    @Test
    public void scansVariables() {
        ParserTestHelper.assertScansTokenType((String)"${x}", (String)"Variable", (boolean)true);
    }

    @Test
    public void translatesVariables() throws Exception {
        ParserTestHelper.assertTranslatesTo((String)"${x}", (VariableSource)new TestVariableSource("x", "y"), (String)"y");
        ParserTestHelper.assertTranslatesTo((String)"${BoBo}", (VariableSource)new TestVariableSource("BoBo", "y"), (String)"y");
        this.assertTranslatesVariable("${x}", "y");
        this.assertTranslatesVariable("${z}", "<span class=\"meta\">undefined variable: z</span>");
        this.assertTranslatesVariable("${}", "${}");
    }

    private void assertTranslatesVariable(String variable, String expected) throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {y}\n" + variable);
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)("<span class=\"meta\">variable defined: x=y</span>" + HtmlElement.endl + "<br/>" + expected));
    }

    @Test
    public void translatesVariableContents() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {''y''}\n|${x}|\n");
        String result = ParserTestHelper.translateTo((WikiPage)pageOne);
        Assert.assertTrue((boolean)result.contains("<i>y</i>"));
    }

    @Test
    public void translatesVariableContentsInLiteralTable() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {''y''}\n!|${x}|\n");
        String result = ParserTestHelper.translateTo((WikiPage)pageOne);
        Assert.assertTrue((!result.contains("<i>y</i>") ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("''y''", result.indexOf("table")) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void evaluatesVariablesAtCurrentLocation() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {y}\n${x}\n!define x {z}\n${x}");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)("<span class=\"meta\">variable defined: x=y</span>" + HtmlElement.endl + "<br/>" + "y" + "<br/>" + "<span class=\"meta\">variable defined: x=z</span>" + HtmlElement.endl + "<br/>" + "z"));
    }

    @Test
    public void evaluatesNestedVariableDefinition() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {y}\n!define z {${x}}\n${z}");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)("<span class=\"meta\">variable defined: x=y</span>" + HtmlElement.endl + "<br/>" + "<span class=\"meta\">variable defined: z=${x}</span>" + HtmlElement.endl + "<br/>" + "y"));
    }

    @Test
    public void evaluatesForwardNestedVariableDefinition() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define z {${x}}\n!define x {y}\n${z}");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)("<span class=\"meta\">variable defined: z=${x}</span>" + HtmlElement.endl + "<br/>" + "<span class=\"meta\">variable defined: x=y</span>" + HtmlElement.endl + "<br/>" + "y"));
    }

    @Test
    public void evaluatesEmptyNestedVariableDefinition() throws Exception {
        WikiPage pageOne = new TestRoot().makePage("PageOne", "!define x {}\n!define z {${x}}\n${z}");
        ParserTestHelper.assertTranslatesTo((WikiPage)pageOne, (String)("<span class=\"meta\">variable defined: x=</span>" + HtmlElement.endl + "<br/>" + "<span class=\"meta\">variable defined: z=${x}</span>" + HtmlElement.endl + "<br/>"));
    }

    @Test
    public void evaluatesVariablesFromParent() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage parent = root.makePage("PageOne", "!define x {y}\n");
        WikiPage child = root.makePage(parent, "PageTwo");
        ParserTestHelper.assertTranslatesTo((WikiPage)child, (String)"${x}", (String)"y");
    }

    @Test
    public void evaluatesVariablesFromParentInCurrentContext() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage parent = root.makePage("PageOne", "!define x {${y}}\n");
        WikiPage child = root.makePage(parent, "PageTwo", "!define y {stuff}\n${x}");
        Assert.assertTrue((boolean)ParserTestHelper.translateTo((WikiPage)child).endsWith("stuff"));
    }

    @Test
    public void evaluatesVariablesFromInclude() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage includer = root.makePage("PageOne", "!include -seamless PageTwo\n${x}");
        root.makePage("PageTwo", "!define x {y}");
        ParserTestHelper.assertTranslatesTo((WikiPage)includer, (String)("<span class=\"meta\">variable defined: x=y</span>" + HtmlElement.endl + "<br/>" + "y"));
    }
}

