/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.WikiWordBuilder;
import fitnesse.wikitext.parser.WikiWordPath;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WikiWordTest {
    private TestRoot root;
    private WikiPage pageOne;
    private WikiPage pageOneTwo;
    private WikiPage pageOneTwoThree;
    private WikiPage pageOneThree;
    private WikiPage root2;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = new TestRoot();
        this.pageOne = this.root.makePage("PageOne");
        this.pageOneTwo = this.root.makePage(this.pageOne, "PageOne2");
        this.pageOneTwoThree = this.root.makePage(this.pageOneTwo, "PageThree");
        this.pageOneThree = this.root.makePage(this.pageOne, "PageThree");
        this.root2 = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root2.getPageCrawler();
    }

    @Test
    public void translatesWikiWords() throws Exception {
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOne, (String)"PageOne", (String)this.wikiLink("PageOne", "PageOne"));
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOneTwo, (String)"PageOne2", (String)this.wikiLink("PageOne.PageOne2", "PageOne2"));
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOneThree, (String)".PageOne", (String)this.wikiLink("PageOne", ".PageOne"));
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOne, (String)">PageOne2", (String)this.wikiLink("PageOne.PageOne2", "&gt;PageOne2"));
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOneTwoThree, (String)"<PageOne", (String)this.wikiLink("PageOne", "&lt;PageOne"));
    }

    @Test
    public void translatesMissingWikiWords() throws Exception {
        ParserTestHelper.assertTranslatesTo((WikiPage)this.pageOne, (String)"PageNine", (String)"PageNine<a title=\"create page\" href=\"PageNine?edit&amp;nonExistent=true\">[?]</a>");
    }

    @Test
    public void regracesWikiWords() throws Exception {
        this.root.setPageData(this.pageOne, "!define REGRACE_LINK {true}\nPageOne\n!define REGRACE_LINK {false}\n");
        Assert.assertTrue((boolean)ParserTestHelper.translateTo((WikiPage)this.pageOne).contains(this.wikiLink("PageOne", "Page One")));
    }

    @Test
    public void testIsSingleWikiWord() throws Exception {
        Assert.assertTrue((boolean)WikiWordPath.isSingleWikiWord((String)"WikiWord"));
        Assert.assertFalse((boolean)WikiWordPath.isSingleWikiWord((String)"notWikiWord"));
        Assert.assertFalse((boolean)WikiWordPath.isSingleWikiWord((String)"NotSingle.WikiWord"));
        Assert.assertFalse((boolean)WikiWordPath.isSingleWikiWord((String)"WikiW\u00f0rd"));
    }

    @Test
    public void testIsWikiWord() throws Exception {
        Assert.assertEquals((Object)true, (Object)WikiWordPath.isWikiWord((String)"HelloThere"));
        Assert.assertEquals((Object)false, (Object)WikiWordPath.isWikiWord((String)"not.a.wiki.word"));
    }

    @Test
    public void testBackwardSearchWidget() throws Exception {
        WikiPage top = this.addPage(this.root2, "TopPage");
        WikiPage target = this.addPage(top, "TargetPage");
        WikiPage referer = this.addPage(target, "ReferingPage");
        WikiPage subTarget = this.addPage(target, "SubTarget");
        String actual = WikiWordBuilder.expandPrefix((WikiPage)referer, (String)"<TargetPage.SubTarget");
        Assert.assertEquals((Object)".TopPage.TargetPage.SubTarget", (Object)actual);
        actual = WikiWordBuilder.expandPrefix((WikiPage)referer, (String)"<NoSuchPage");
        Assert.assertEquals((Object)".NoSuchPage", (Object)actual);
        PageData data = referer.getData();
        data.setContent("<TargetPage.SubTarget");
        referer.commit(data);
        String renderedLink = referer.getData().getHtml();
        Assert.assertEquals((Object)"<a href=\"TopPage.TargetPage.SubTarget\">&lt;TargetPage.SubTarget</a>", (Object)renderedLink);
    }

    private WikiPage addPage(WikiPage parent, String childName) throws Exception {
        return this.crawler.addPage(parent, PathParser.parse((String)childName));
    }

    private String wikiLink(String link, String text) {
        return "<a href=\"" + link + "\">" + text + "</a>";
    }
}

